/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import virtuoso.jena.driver.VirtGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtResSetQIter
implements ClosableIterator<Quad> {
    protected Quad v_row;
    protected TripleMatch v_in;
    protected boolean v_finished = false;
    protected boolean v_prefetched = false;
    protected VirtGraph v_graph = null;
    protected Iterator<Node> v_gList = null;
    protected Node v_curGraph = null;
    protected ExtendedIterator<Triple> v_curTriples = null;

    public VirtResSetQIter() {
        this.v_finished = true;
    }

    public VirtResSetQIter(VirtGraph virtGraph, Iterator<Node> iterator, TripleMatch tripleMatch) {
        this.v_in = tripleMatch;
        this.v_graph = virtGraph;
        this.v_gList = iterator;
        if (this.v_gList.hasNext()) {
            this.v_curGraph = this.v_gList.next();
            this.v_curTriples = this.v_graph.graphBaseFind(this.v_curGraph.toString(), this.v_in);
        }
    }

    public boolean hasNext() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        return !this.v_finished;
    }

    public Quad next() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        this.v_prefetched = false;
        if (this.v_finished) {
            throw new NoSuchElementException();
        }
        return this.getRow();
    }

    public void remove() {
        if (this.v_row != null && this.v_graph != null) {
            this.v_graph.performDelete(this.v_row.getGraph().toString(), this.v_row.getSubject(), this.v_row.getPredicate(), this.v_row.getObject());
            this.v_row = null;
        }
    }

    protected void moveForward() {
        try {
            if (!this.v_finished && this.v_curTriples != null) {
                if (this.v_curTriples.hasNext()) {
                    this.extractRow();
                    this.v_prefetched = true;
                } else if (this.v_gList.hasNext()) {
                    do {
                        this.v_curTriples.close();
                        this.v_curGraph = this.v_gList.next();
                        this.v_curTriples = this.v_graph.graphBaseFind(this.v_curGraph.toString(), this.v_in);
                    } while (!this.v_curTriples.hasNext());
                    this.extractRow();
                    this.v_prefetched = true;
                } else {
                    this.close();
                }
            } else {
                this.close();
            }
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    protected void extractRow() throws Exception {
        Triple triple = (Triple)this.v_curTriples.next();
        this.v_row = new Quad(this.v_curGraph, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    protected Quad getRow() {
        return this.v_row;
    }

    public void close() {
        if (!this.v_finished && this.v_curTriples != null) {
            try {
                this.v_curTriples.close();
                this.v_curTriples = null;
            }
            catch (Exception exception) {
                throw new JenaException((Throwable)exception);
            }
        }
        this.v_finished = true;
    }

    protected void finalize() throws SQLException {
        if (!this.v_finished && this.v_curTriples != null) {
            this.close();
        }
    }
}

