//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  @class RunnerManager plasma/runnermanager.h <Plasma/RunnerManager>
    ///  See <see cref="IRunnerManagerSignals"></see> for signals emitted by RunnerManager
    /// </remarks>        <short> The RunnerManager class decides what installed runners are runnable,         and their ratings. It is the main proxy to the runners.  </short>
    [SmokeClass("Plasma::RunnerManager")]
    public class RunnerManager : QObject, IDisposable {
        protected RunnerManager(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(RunnerManager), this);
        }
        public RunnerManager(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("RunnerManager#", "RunnerManager(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public RunnerManager() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("RunnerManager", "RunnerManager()", typeof(void));
        }
        public RunnerManager(KConfigGroup config, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("RunnerManager##", "RunnerManager(KConfigGroup&, QObject*)", typeof(void), typeof(KConfigGroup), config, typeof(QObject), parent);
        }
        public RunnerManager(KConfigGroup config) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("RunnerManager#", "RunnerManager(KConfigGroup&)", typeof(void), typeof(KConfigGroup), config);
        }
        /// <remarks>
        ///  Finds and returns a loaded runner or NULL
        ///  @arg name the name of the runner
        /// </remarks>        <return> Pointer to the runner
        ///          </return>
        ///         <short>    Finds and returns a loaded runner or NULL  @arg name the name of the runner </short>
        public Plasma.AbstractRunner Runner(string name) {
            return (Plasma.AbstractRunner) interceptor.Invoke("runner$", "runner(const QString&) const", typeof(Plasma.AbstractRunner), typeof(string), name);
        }
        /// <remarks>
        /// </remarks>        <return> the currently active "single mode" runner, or null if none
        /// </return>
        ///         <short>   </short>
        public Plasma.AbstractRunner SingleModeRunner() {
            return (Plasma.AbstractRunner) interceptor.Invoke("singleModeRunner", "singleModeRunner() const", typeof(Plasma.AbstractRunner));
        }
        /// <remarks>
        ///  Puts the manager into "single runner" mode using the given
        ///  runner; if the runner does not exist or can not be loaded then
        ///  the single runner mode will not be started and singleModeRunner()
        ///  will return NULL
        ///  @arg id the id of the runner to use
        /// </remarks>        <short>    Puts the manager into "single runner" mode using the given  runner; if the runner does not exist or can not be loaded then  the single runner mode will not be started and singleModeRunner()  will return NULL  @arg id the id of the runner to use </short>
        public void SetSingleModeRunnerId(string id) {
            interceptor.Invoke("setSingleModeRunnerId$", "setSingleModeRunnerId(const QString&)", typeof(void), typeof(string), id);
        }
        /// <remarks>
        /// </remarks>        <return> the id of the runner to use in single mode
        /// </return>
        ///         <short>   </short>
        public string SingleModeRunnerId() {
            return (string) interceptor.Invoke("singleModeRunnerId", "singleModeRunnerId() const", typeof(string));
        }
        /// <remarks>
        /// </remarks>        <return> true if the manager is set to run in single runner mode
        /// </return>
        ///         <short>   </short>
        public bool SingleMode() {
            return (bool) interceptor.Invoke("singleMode", "singleMode() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets whether or not the manager is in single mode.
        ///  @arg singleMode true if the manager should be in single mode, false otherwise
        /// </remarks>        <short>    Sets whether or not the manager is in single mode.</short>
        public void SetSingleMode(bool singleMode) {
            interceptor.Invoke("setSingleMode$", "setSingleMode(bool)", typeof(void), typeof(bool), singleMode);
        }
        /// <remarks>
        ///  Returns the translated name of a runner
        ///  @arg id the id of the runner
        /// </remarks>        <short>    Returns the translated name of a runner  @arg id the id of the runner </short>
        public string RunnerName(string id) {
            return (string) interceptor.Invoke("runnerName$", "runnerName(const QString&) const", typeof(string), typeof(string), id);
        }
        /// <remarks>
        /// </remarks>        <return> the list of all currently loaded runners
        ///          </return>
        ///         <short>   </short>
        public List<Plasma.AbstractRunner> Runners() {
            return (List<Plasma.AbstractRunner>) interceptor.Invoke("runners", "runners() const", typeof(List<Plasma.AbstractRunner>));
        }
        /// <remarks>
        /// </remarks>        <return> the names of all runners that advertise single query mode
        /// </return>
        ///         <short>   </short>
        public List<string> SingleModeAdvertisedRunnerIds() {
            return (List<string>) interceptor.Invoke("singleModeAdvertisedRunnerIds", "singleModeAdvertisedRunnerIds() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Retrieves the current context
        /// </remarks>        <return> pointer to the current context
        ///          </return>
        ///         <short>    Retrieves the current context </short>
        public Plasma.RunnerContext SearchContext() {
            return (Plasma.RunnerContext) interceptor.Invoke("searchContext", "searchContext() const", typeof(Plasma.RunnerContext));
        }
        /// <remarks>
        ///  Retrieves all available matches found so far for the previously launched query
        /// </remarks>        <return> List of matches
        ///          </return>
        ///         <short>    Retrieves all available matches found so far for the previously launched query </short>
        public List<Plasma.QueryMatch> Matches() {
            return (List<Plasma.QueryMatch>) interceptor.Invoke("matches", "matches() const", typeof(List<Plasma.QueryMatch>));
        }
        /// <remarks>
        ///  Runs a given match
        ///  @arg match the match to be executed
        ///          </remarks>        <short>    Runs a given match  @arg match the match to be executed          </short>
        public void Run(Plasma.QueryMatch match) {
            interceptor.Invoke("run#", "run(const Plasma::QueryMatch&)", typeof(void), typeof(Plasma.QueryMatch), match);
        }
        /// <remarks>
        ///  Runs a given match
        ///  @arg id the id of the match to run
        ///          </remarks>        <short>    Runs a given match  @arg id the id of the match to run          </short>
        public void Run(string id) {
            interceptor.Invoke("run$", "run(const QString&)", typeof(void), typeof(string), id);
        }
        /// <remarks>
        ///  Retrieves the list of actions, if any, for a match
        ///          </remarks>        <short>    Retrieves the list of actions, if any, for a match          </short>
        public List<QAction> ActionsForMatch(Plasma.QueryMatch match) {
            return (List<QAction>) interceptor.Invoke("actionsForMatch#", "actionsForMatch(const Plasma::QueryMatch&)", typeof(List<QAction>), typeof(Plasma.QueryMatch), match);
        }
        /// <remarks>
        /// </remarks>        <return> the current query term
        ///          </return>
        ///         <short>   </short>
        public string Query() {
            return (string) interceptor.Invoke("query", "query() const", typeof(string));
        }
        /// <remarks>
        ///  Causes a reload of the current configuration
        ///          </remarks>        <short>    Causes a reload of the current configuration          </short>
        public void ReloadConfiguration() {
            interceptor.Invoke("reloadConfiguration", "reloadConfiguration()", typeof(void));
        }
        /// <remarks>
        ///  Sets a whitelist for the plugins that can be loaded
        ///  @arg plugins the plugin names of allowed runners
        /// </remarks>        <short>    Sets a whitelist for the plugins that can be loaded </short>
        public void SetAllowedRunners(List<string> runners) {
            interceptor.Invoke("setAllowedRunners?", "setAllowedRunners(const QStringList&)", typeof(void), typeof(List<string>), runners);
        }
        /// <remarks>
        /// </remarks>        <return> the list of allowed plugins
        /// </return>
        ///         <short>   </short>
        public List<string> AllowedRunners() {
            return (List<string>) interceptor.Invoke("allowedRunners", "allowedRunners() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Call this method when the runners should be prepared for a query session.
        ///  Call matchSessionComplete when the query session is finished for the time
        ///  being.
        /// </remarks>        <short>    Call this method when the runners should be prepared for a query session.</short>
        ///         <see> matchSessionComplete</see>
        [Q_SLOT("void setupMatchSession()")]
        public void SetupMatchSession() {
            interceptor.Invoke("setupMatchSession", "setupMatchSession()", typeof(void));
        }
        /// <remarks>
        ///  Call this method when the query session is finished for the time
        ///  being.
        /// </remarks>        <short>    Call this method when the query session is finished for the time  being.</short>
        ///         <see> prepareForMatchSession</see>
        [Q_SLOT("void matchSessionComplete()")]
        public void MatchSessionComplete() {
            interceptor.Invoke("matchSessionComplete", "matchSessionComplete()", typeof(void));
        }
        /// <remarks>
        ///  Launch a query, this will create threads and return inmediately.
        ///  When the information will be available can be known using the
        ///  matchesChanged signal.
        ///  @arg term the term we want to find matches for
        ///  @arg runnerId optional, if only one specific runner is to be used;
        ///                providing an id will put the manager into single runner mode
        ///          </remarks>        <short>    Launch a query, this will create threads and return inmediately.</short>
        [Q_SLOT("void launchQuery(QString, QString)")]
        public void LaunchQuery(string term, string runnerId) {
            interceptor.Invoke("launchQuery$$", "launchQuery(const QString&, const QString&)", typeof(void), typeof(string), term, typeof(string), runnerId);
        }
        /// <remarks>
        ///  Convenience version of above
        ///          </remarks>        <short>    Convenience version of above          </short>
        [Q_SLOT("void launchQuery(QString)")]
        public void LaunchQuery(string term) {
            interceptor.Invoke("launchQuery$", "launchQuery(const QString&)", typeof(void), typeof(string), term);
        }
        /// <remarks>
        ///  Execute a query, this method will only return when the query is executed
        ///  This means that the method may be dangerous as it wait a variable amount
        ///  of time for the runner to finish.
        ///  The runner parameter is mandatory, to avoid launching unwanted runners.
        ///  @arg term the term we want to find matches for
        ///  @arg runner the runner we will use, it is mandatory
        /// </remarks>        <return> 0 if nothing was launched, 1 if launched.
        ///          </return>
        ///         <short>    Execute a query, this method will only return when the query is executed  This means that the method may be dangerous as it wait a variable amount  of time for the runner to finish.</short>
        [Q_SLOT("bool execQuery(QString, QString)")]
        public bool ExecQuery(string term, string runnerName) {
            return (bool) interceptor.Invoke("execQuery$$", "execQuery(const QString&, const QString&)", typeof(bool), typeof(string), term, typeof(string), runnerName);
        }
        /// <remarks>
        ///  Convenience version of above
        ///          </remarks>        <short>    Convenience version of above          </short>
        [Q_SLOT("bool execQuery(QString)")]
        public bool ExecQuery(string term) {
            return (bool) interceptor.Invoke("execQuery$", "execQuery(const QString&)", typeof(bool), typeof(string), term);
        }
        /// <remarks>
        ///  Reset the current data and stops the query
        ///          </remarks>        <short>    Reset the current data and stops the query          </short>
        [Q_SLOT("void reset()")]
        public void Reset() {
            interceptor.Invoke("reset", "reset()", typeof(void));
        }
        ~RunnerManager() {
            interceptor.Invoke("~RunnerManager", "~RunnerManager()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~RunnerManager", "~RunnerManager()", typeof(void));
        }
        protected new IRunnerManagerSignals Emit {
            get { return (IRunnerManagerSignals) Q_EMIT; }
        }
    }

    public interface IRunnerManagerSignals : IQObjectSignals {
        /// <remarks>
        ///  Emitted each time a new match is added to the list
        ///          </remarks>        <short>    Emitted each time a new match is added to the list          </short>
        [Q_SIGNAL("void matchesChanged(QList<Plasma::QueryMatch>)")]
        void MatchesChanged(List<Plasma.QueryMatch> matches);
    }
}
