//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMMATERIAL_H
#define PMMATERIAL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmtexturebase.h"

/**
 * Class for povray materials
 */
class PMMaterial : public PMTextureBase
{
   typedef PMTextureBase Base;
public:
   /** Creates an PMMaterial */
   PMMaterial( );
   /** Deletes the object */
   virtual ~PMMaterial( );
   
   /** */
   virtual PMObject* newObject( ) const { return new PMMaterial( ); }
   /** */
   virtual QString className( ) const { return QString( "material" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTMaterial; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;

   /** Returns a new @ref PMMaterialEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmmaterial" ); }

private:
   /** IDs for @ref PMMementoData */
//   enum PMMaterialMementoID { };
   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;
};


#endif
