/***************************************************************************
                            ProcessingInstruction.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef PROCESSINGINSTRUCTION_H
#define PROCESSINGINSTRUCTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/DOMNode.h>

/**

 The <code> ProcessingInstruction </code> interface represents a
 &quot;processing instruction&quot;, used in XML as a way to keep
 processor-specific information in the text of the document.

 
 @short 
 The <code> ProcessingInstruction </code> interface represents a
 &quot;processing instruction&quot;, used in XML as a way to keep
 processor-specific information in the text of the document.
*/

@class StyleSheet;

@interface ProcessingInstruction : DOMNode
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 The target of this processing instruction. XML defines this as
 being the first token following the markup that begins the
 processing instruction.

     
*/
- (NSString *) target;

/** 
 The content of this processing instruction. This is from the
 first non white space character after the target to the
 character immediately preceding the <code> ?&gt; </code> .

     
*/
- (NSString *) data;

/** 
 see @ref data

     
*/
- setData: (NSString *)arg1;

/** 
 Introduced in DOM Level 2
 This method is from the LinkStyle interface

 The style sheet.
     
*/
- (StyleSheet*) sheet;
@end

#endif
