/***************************************************************************
                            kde_EntityReference.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_ENTITYREFERENCE
#define KDE_ENTITYREFERENCE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 <code> EntityReference </code> objects may be inserted into the
 structure model when an entity reference is in the source document,
 or when the user wishes to insert an entity reference. Note that
 character references and references to predefined entities are
 considered to be expanded by the HTML or XML processor so that
 characters are represented by their Unicode equivalent rather than
 by an entity reference. Moreover, the XML processor may completely
 expand references to entities while building the structure model,
 instead of providing <code> EntityReference </code> objects. If it
 does provide such objects, then for a given <code> EntityReference
 </code> node, it may be that there is no <code> Entity </code> node
 representing the referenced entity; but if such an <code> Entity
 </code> exists, then the child list of the <code> EntityReference
 </code> node is the same as that of the <code> Entity </code> node.
 As with the <code> Entity </code> node, all descendants of the
 <code> EntityReference </code> are readonly.

  The resolution of the children of the <code> EntityReference
 </code> (the replacement value of the referenced <code> Entity
 </code> ) may be lazily evaluated; actions by the user (such as
 calling the <code> childNodes </code> method on the <code>
 EntityReference </code> node) are assumed to trigger the
 evaluation.

 
 @short *
 <code> EntityReference </code> objects may be inserted into the
 structure model when an entity reference is in the source document,
 or when the user wishes to insert an entity reference.
*/
kde_EntityReference * kde_new_EntityReference();
kde_EntityReference * kde_new_EntityReference1(kde_EntityReference* other);
kde_EntityReference * kde_new_EntityReference2(kde_DOMNode* other);
void kde_del_EntityReference( kde_EntityReference* p );

#endif
