/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import sun.plugin.security.CertificateStore;
import sun.plugin.util.Trace;
import sun.plugin.util.UserProfile;

public final class HttpsRootCACertStore
implements CertificateStore {
    private static String _filename = null;
    private KeyStore _jssecacerts = null;

    static {
        _filename = UserProfile.getHttpsRootCertFile();
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.loading", new Object[]{_filename});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file;
                    if (HttpsRootCACertStore.this._jssecacerts == null) {
                        HttpsRootCACertStore.this._jssecacerts = KeyStore.getInstance("JKS");
                        HttpsRootCACertStore.this._jssecacerts.load(null, null);
                    }
                    if ((file = new File(_filename)).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        HttpsRootCACertStore.this._jssecacerts.load(bufferedInputStream, null);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    } else {
                        Trace.msgSecurityPrintln("roothttpscertstore.cert.noload", new Object[]{_filename});
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("roothttpscertstore.cert.loaded", new Object[]{_filename});
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.saving", new Object[]{_filename});
    }

    public KeyStore getKeyStore() {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.getkeystore");
        return this._jssecacerts;
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.adding");
        throw new KeyStoreException("Cannot add Https root CA certificate");
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.removing");
        throw new KeyStoreException("Cannot remove Https root CA certificate");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.instore");
        return false;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.canverify");
        Trace.msgSecurityPrintln("roothttpscertstore.cert.tobeverified", new Object[]{certificate});
        Enumeration<String> enumeration = this._jssecacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate2 = this._jssecacerts.getCertificate(string);
            Trace.msgSecurityPrintln("roothttpscertstore.cert.tobecompared", new Object[]{certificate2});
            try {
                certificate.verify(certificate2.getPublicKey());
                Trace.msgSecurityPrintln("roothttpscertstore.cert.verify.ok");
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        Trace.msgSecurityPrintln("roothttpscertstore.cert.verify.fail");
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        Trace.msgSecurityPrintln("roothttpscertstore.cert.iterator");
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._jssecacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._jssecacerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }
}

