/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform.stream;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;

public class StreamSource
implements Source {
    public static final String FEATURE = "http://javax.xml.transform.stream.StreamSource/feature";
    private String publicId;
    private String systemId;
    private InputStream inputStream;
    private Reader reader;

    public StreamSource() {
    }

    public StreamSource(File file) {
        this.setSystemId(file);
    }

    public void setSystemId(File file) {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        this.systemId = string.startsWith("/") ? "file://" + string : "file:///" + string;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public StreamSource(InputStream inputStream) {
        this.setInputStream(inputStream);
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public Reader getReader() {
        return this.reader;
    }

    public StreamSource(Reader reader) {
        this.setReader(reader);
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public StreamSource(String string) {
        this.systemId = string;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public StreamSource(InputStream inputStream, String string) {
        this.setInputStream(inputStream);
        this.setSystemId(string);
    }

    public StreamSource(Reader reader, String string) {
        this.setReader(reader);
        this.setSystemId(string);
    }
}

