/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractActionPropertyChangeListener;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;

public class JTextField
extends JTextComponent
implements SwingConstants {
    private Action action;
    private PropertyChangeListener actionPropertyChangeListener;
    public static final String notifyAction = "notify-field-accept";
    private BoundedRangeModel visibility;
    private int horizontalAlignment = 10;
    private int columns;
    private int columnWidth;
    private String command;
    private static final Action[] defaultActions = new Action[]{new NotifyAction()};
    private static final String uiClassID = "TextFieldUI";

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.columnWidth = fontMetrics.charWidth('m');
        }
        return this.columnWidth;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getScrollOffset() {
        return this.visibility.getValue();
    }

    public JTextField() {
        this(null, null, 0);
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n2 = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n2 = ((ActionEvent)aWTEvent).getModifiers();
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.command != null ? this.command : this.getText(), EventQueue.getMostRecentEventTime(), n2);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$java$awt$event$ActionListener == null ? JTextField.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)objectArray[i2 + 1]).actionPerformed(actionEvent);
        }
    }

    public void postActionEvent() {
        this.fireActionPerformed();
    }

    boolean hasActionListener() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$java$awt$event$ActionListener == null ? JTextField.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidateRoot() {
        Container container = this.getParent();
        return !(container instanceof JViewport);
    }

    public JTextField(int n2) {
        this(null, null, n2);
    }

    public void setColumns(int n2) {
        int n3 = this.columns;
        if (n2 < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (n2 != n3) {
            this.columns = n2;
            this.invalidate();
        }
    }

    public void setHorizontalAlignment(int n2) {
        if (n2 == this.horizontalAlignment) {
            return;
        }
        int n3 = this.horizontalAlignment;
        if (n2 != 2 && n2 != 0 && n2 != 4 && n2 != 10 && n2 != 11) {
            throw new IllegalArgumentException("horizontalAlignment");
        }
        this.horizontalAlignment = n2;
        this.firePropertyChange("horizontalAlignment", n3, this.horizontalAlignment);
        this.invalidate();
        this.repaint();
    }

    public void setScrollOffset(int n2) {
        this.visibility.setValue(n2);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.columns != 0) {
            Insets insets = this.getInsets();
            dimension.width = this.columns * this.getColumnWidth() + insets.left + insets.right;
        }
        return dimension;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.columnWidth = 0;
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Insets insets = this.getInsets();
        int n2 = rectangle.x + this.visibility.getValue() - insets.left;
        if (n2 < this.visibility.getValue()) {
            this.visibility.setValue(n2);
        } else if (n2 > this.visibility.getValue() + this.visibility.getExtent()) {
            this.visibility.setValue(n2 - this.visibility.getExtent());
        }
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener != null && this.getAction() == actionListener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(ActionListener.class, actionListener);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.horizontalAlignment == 2 ? "LEFT" : (this.horizontalAlignment == 0 ? "CENTER" : (this.horizontalAlignment == 4 ? "RIGHT" : (this.horizontalAlignment == 10 ? "LEADING" : (this.horizontalAlignment == 11 ? "TRAILING" : ""))));
        String string2 = this.command != null ? this.command : "";
        return super.paramString() + ",columns=" + this.columns + ",columnWidth=" + this.columnWidth + ",command=" + string2 + ",horizontalAlignment=" + string;
    }

    public JTextField(String string) {
        this(null, string, 0);
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public JTextField(String string, int n2) {
        this(null, string, n2);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextField();
        }
        return this.accessibleContext;
    }

    public Action getAction() {
        return this.action;
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    protected void configurePropertiesFromAction(Action action) {
        this.setEnabled(action != null ? action.isEnabled() : true);
        this.setToolTipText(action != null ? (String)action.getValue("ShortDescription") : null);
    }

    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (this.action == null || !this.action.equals(action)) {
            this.action = action;
            if (action2 != null) {
                this.removeActionListener(action2);
                action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
            this.configurePropertiesFromAction(this.action);
            if (this.action != null) {
                if (!this.isListener(ActionListener.class, this.action)) {
                    this.addActionListener(this.action);
                }
                this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.firePropertyChange("action", action2, this.action);
            this.revalidate();
            this.repaint();
        }
    }

    public BoundedRangeModel getHorizontalVisibility() {
        return this.visibility;
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public void setDocument(Document document) {
        if (document != null) {
            document.putProperty("filterNewlines", Boolean.TRUE);
        }
        super.setDocument(document);
    }

    private boolean isListener(Class clazz, ActionListener actionListener) {
        boolean bl2 = false;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != clazz || objectArray[i2 + 1] != actionListener) continue;
            bl2 = true;
        }
        return bl2;
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new AbstractActionPropertyChangeListener(this, action){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                JTextField jTextField = (JTextField)this.getTarget();
                if (jTextField == null) {
                    Action action = (Action)propertyChangeEvent.getSource();
                    action.removePropertyChangeListener(this);
                } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    jTextField.setToolTipText(string2);
                } else if (string.equals("enabled")) {
                    Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                    jTextField.setEnabled(bl2);
                    jTextField.repaint();
                }
            }
        };
    }

    public JTextField(Document document, String string, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        this.visibility = new DefaultBoundedRangeModel();
        this.visibility.addChangeListener(new ScrollRepainter());
        this.columns = n2;
        if (document == null) {
            document = this.createDefaultModel();
        }
        this.setDocument(document);
        if (string != null) {
            this.setText(string);
        }
    }

    protected class AccessibleJTextField
    extends JTextComponent.AccessibleJTextComponent {
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            return accessibleStateSet;
        }

        protected AccessibleJTextField() {
        }
    }

    static class NotifyAction
    extends TextAction {
        NotifyAction() {
            super(JTextField.notifyAction);
        }

        public boolean isEnabled() {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JTextField) {
                return ((JTextField)jTextComponent).hasActionListener();
            }
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jTextComponent;
                jTextField.postActionEvent();
            }
        }
    }

    class ScrollRepainter
    implements ChangeListener,
    Serializable {
        ScrollRepainter() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTextField.this.repaint();
        }
    }
}

