/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java2d.AnimatingSurface;
import java2d.DemoFonts;
import java2d.DemoImages;
import java2d.DemoPanel;
import java2d.GlobalControls;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

public abstract class Surface
extends JPanel
implements Printable {
    public Object AntiAlias = RenderingHints.VALUE_ANTIALIAS_ON;
    public Object Rendering = RenderingHints.VALUE_RENDER_SPEED;
    public AlphaComposite composite;
    public Paint texture;
    public String perfStr;
    public BufferedImage bimg;
    public int imageType;
    public String name;
    public boolean clearSurface = true;
    public boolean dontThread;
    public AnimatingSurface animating;
    protected long sleepAmount = 50L;
    private long orig;
    private long start;
    private long frame;
    private Toolkit toolkit;
    private boolean perfMonitor;
    private boolean outputPerf;
    private int biw;
    private int bih;
    private boolean clearOnce;
    private boolean toBeInitialized = true;
    static byte[] lut1Arr = new byte[]{0, -1};
    static byte[] lut2Arr = new byte[]{0, 85, -86, -1};
    static byte[] lut4Arr = new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1};
    private static final int REPORTFRAMES = 30;

    public Surface() {
        this.setDoubleBuffered(this instanceof AnimatingSurface);
        this.toolkit = this.getToolkit();
        this.name = this.getClass().getName();
        this.name = this.name.substring(this.name.indexOf(".", 7) + 1);
        this.setImageType(0);
        try {
            if (System.getProperty("java2demo.perf") != null) {
                this.outputPerf = true;
                this.perfMonitor = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this instanceof AnimatingSurface) {
            this.animating = (AnimatingSurface)this;
        }
    }

    protected Image getImage(String string) {
        return DemoImages.getImage(string, this);
    }

    protected Font getFont(String string) {
        return DemoFonts.getFont(string);
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setImageType(int n) {
        this.imageType = n == 0 ? (this instanceof AnimatingSurface ? 2 : 1) : n;
        this.bimg = null;
    }

    public void setAntiAlias(boolean bl) {
        this.AntiAlias = bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
    }

    public void setRendering(boolean bl) {
        this.Rendering = bl ? RenderingHints.VALUE_RENDER_QUALITY : RenderingHints.VALUE_RENDER_SPEED;
    }

    public void setTexture(Object object) {
        this.texture = object instanceof GradientPaint ? new GradientPaint(0.0f, 0.0f, Color.white, this.getSize().width * 2, 0.0f, Color.green) : (Paint)object;
    }

    public void setComposite(boolean bl) {
        this.composite = bl ? AlphaComposite.getInstance(3, 0.5f) : null;
    }

    public void setMonitor(boolean bl) {
        this.perfMonitor = bl;
    }

    public void setSleepAmount(long l) {
        this.sleepAmount = l;
    }

    public long getSleepAmount() {
        return this.sleepAmount;
    }

    public BufferedImage createBufferedImage(Graphics2D graphics2D, int n, int n2, int n3) {
        BufferedImage bufferedImage = null;
        if (n3 == 0) {
            bufferedImage = graphics2D.getDeviceConfiguration().createCompatibleImage(n, n2);
        } else if (n3 > 0 && n3 < 14) {
            bufferedImage = new BufferedImage(n, n2, n3);
        } else if (n3 == 14) {
            bufferedImage = this.createBinaryImage(n, n2, 2);
        } else if (n3 == 15) {
            bufferedImage = this.createBinaryImage(n, n2, 4);
        } else if (n3 == 16) {
            bufferedImage = this.createSGISurface(n, n2, 32);
        } else if (n3 == 17) {
            bufferedImage = this.createSGISurface(n, n2, 16);
        }
        this.biw = n;
        this.bih = n2;
        return bufferedImage;
    }

    private BufferedImage createBinaryImage(int n, int n2, int n3) {
        int n4 = n * n3 / 8;
        if (n * n3 % 8 != 0) {
            ++n4;
        }
        byte[] byArray = new byte[n2 * n4];
        IndexColorModel indexColorModel = null;
        switch (n3) {
            case 1: {
                indexColorModel = new IndexColorModel(n3, lut1Arr.length, lut1Arr, lut1Arr, lut1Arr);
                break;
            }
            case 2: {
                indexColorModel = new IndexColorModel(n3, lut2Arr.length, lut2Arr, lut2Arr, lut2Arr);
                break;
            }
            case 4: {
                indexColorModel = new IndexColorModel(n3, lut4Arr.length, lut4Arr, lut4Arr, lut4Arr);
                break;
            }
            default: {
                new Exception("Invalid # of bit per pixel").printStackTrace();
            }
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n3, null);
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }

    private BufferedImage createSGISurface(int n, int n2, int n3) {
        int n4 = -16777216;
        int n5 = 63488;
        int n6 = 0xFF0000;
        int n7 = 1984;
        int n8 = 65280;
        int n9 = 62;
        DirectColorModel directColorModel = null;
        DataBuffer dataBuffer = null;
        WritableRaster writableRaster = null;
        switch (n3) {
            case 16: {
                short[] sArray = new short[n * n2];
                directColorModel = new DirectColorModel(16, n5, n7, n9);
                dataBuffer = new DataBufferUShort(sArray, sArray.length);
                writableRaster = Raster.createPackedRaster(dataBuffer, n, n2, n, new int[]{n5, n7, n9}, null);
                break;
            }
            case 32: {
                int[] nArray = new int[n * n2];
                directColorModel = new DirectColorModel(32, n4, n6, n8);
                dataBuffer = new DataBufferInt(nArray, nArray.length);
                writableRaster = Raster.createPackedRaster(dataBuffer, n, n2, n, new int[]{n4, n6, n8}, null);
                break;
            }
            default: {
                new Exception("Invalid # of bit per pixel").printStackTrace();
            }
        }
        return new BufferedImage(directColorModel, writableRaster, false, null);
    }

    public Graphics2D createGraphics2D(int n, int n2, BufferedImage bufferedImage, Graphics graphics) {
        Graphics2D graphics2D = null;
        graphics2D = bufferedImage != null ? bufferedImage.createGraphics() : (Graphics2D)graphics;
        graphics2D.setBackground(this.getBackground());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.AntiAlias);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, this.Rendering);
        if (this.clearSurface || this.clearOnce) {
            graphics2D.clearRect(0, 0, n, n2);
            this.clearOnce = false;
        }
        if (this.texture != null) {
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.setPaint(this.texture);
            graphics2D.fillRect(0, 0, n, n2);
        }
        if (this.composite != null) {
            graphics2D.setComposite(this.composite);
        }
        return graphics2D;
    }

    public abstract void render(int var1, int var2, Graphics2D var3);

    public void paintImmediately(int n, int n2, int n3, int n4) {
        RepaintManager repaintManager = null;
        boolean bl = true;
        if (!this.isDoubleBuffered()) {
            repaintManager = RepaintManager.currentManager(this);
            bl = repaintManager.isDoubleBufferingEnabled();
            repaintManager.setDoubleBufferingEnabled(false);
        }
        super.paintImmediately(n, n2, n3, n4);
        if (repaintManager != null) {
            repaintManager.setDoubleBufferingEnabled(bl);
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.imageType == 1) {
            this.bimg = null;
        } else if (this.bimg == null || this.biw != dimension.width || this.bih != dimension.height) {
            this.bimg = this.createBufferedImage((Graphics2D)graphics, dimension.width, dimension.height, this.imageType - 2);
            this.clearOnce = true;
            this.toBeInitialized = true;
        }
        if (this.toBeInitialized) {
            if (this.animating != null) {
                this.animating.reset(dimension.width, dimension.height);
            }
            this.toBeInitialized = false;
            this.startClock();
        }
        if (this.animating != null && this.animating.thread != null) {
            this.animating.step(dimension.width, dimension.height);
        }
        Graphics2D graphics2D = this.createGraphics2D(dimension.width, dimension.height, this.bimg, graphics);
        this.render(dimension.width, dimension.height, graphics2D);
        graphics2D.dispose();
        if (this.bimg != null) {
            graphics.drawImage(this.bimg, 0, 0, null);
            this.toolkit.sync();
        }
        if (this.perfMonitor) {
            this.LogPerformance();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.translate(pageFormat.getImageableWidth() / 2.0, pageFormat.getImageableHeight() / 2.0);
        Dimension dimension = this.getSize();
        double d = Math.min(pageFormat.getImageableWidth() / (double)dimension.width, pageFormat.getImageableHeight() / (double)dimension.height);
        if (d < 1.0) {
            graphics2D.scale(d, d);
        }
        graphics2D.translate((double)(-dimension.width) / 2.0, (double)(-dimension.height) / 2.0);
        if (this.bimg == null) {
            Graphics2D graphics2D2 = this.createGraphics2D(dimension.width, dimension.height, null, graphics2D);
            this.render(dimension.width, dimension.height, graphics2D2);
            graphics2D2.dispose();
        } else {
            graphics2D.drawImage((Image)this.bimg, 0, 0, this);
        }
        return 0;
    }

    public void startClock() {
        this.start = this.orig = System.currentTimeMillis();
        this.frame = 0L;
    }

    private void LogPerformance() {
        if (this.frame % 30L == 0L) {
            long l = System.currentTimeMillis();
            long l2 = l - this.start;
            long l3 = l - this.orig;
            if (this.frame == 0L) {
                this.perfStr = this.name + " " + l2 + " ms";
                if (this.animating == null || this.animating.thread == null) {
                    this.frame = -1L;
                }
            } else {
                String string = Float.toString(30.0f / ((float)l2 / 1000.0f));
                string = string.length() < 4 ? string.substring(0, string.length()) : string.substring(0, 4);
                this.perfStr = this.name + " " + string + " fps";
            }
            if (this.outputPerf) {
                System.out.println(this.perfStr);
            }
            this.start = l;
        }
        ++this.frame;
    }

    public void verbose() {
        String string = "  " + this.name + " ";
        if (this.animating != null && this.animating.thread != null) {
            string = string.concat(" Running");
        } else if (this instanceof AnimatingSurface) {
            string = string.concat(" Stopped");
        }
        string = string.concat(" " + GlobalControls.screenCombo.getSelectedItem());
        string = this.AntiAlias == RenderingHints.VALUE_ANTIALIAS_ON ? string.concat(" ANTIALIAS_ON ") : string.concat(" ANTIALIAS_OFF ");
        String string2 = string = this.Rendering == RenderingHints.VALUE_RENDER_QUALITY ? string.concat("RENDER_QUALITY ") : string.concat("RENDER_SPEED ");
        if (this.texture != null) {
            string = string.concat("Texture ");
        }
        if (this.composite != null) {
            string = string.concat("Composite=" + this.composite.getAlpha() + " ");
        }
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        float f = runtime.freeMemory();
        float f2 = runtime.totalMemory();
        string = string.concat((f2 - f) / 1024.0f + "K used");
        System.out.println(string);
    }

    public static void createDemoFrame(Surface surface) {
        final DemoPanel demoPanel = new DemoPanel(surface);
        Frame frame = new Frame("Java2D Demo - " + surface.name);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                demoPanel.start();
            }

            public void windowIconified(WindowEvent windowEvent) {
                demoPanel.stop();
            }
        });
        frame.add("Center", demoPanel);
        frame.pack();
        frame.setSize(new Dimension(500, 300));
        frame.setVisible(true);
        if (surface.animating != null) {
            surface.animating.start();
        }
    }
}

