/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import sun.tools.javap.AttrData;
import sun.tools.javap.CPX;
import sun.tools.javap.CPX2;
import sun.tools.javap.FieldData;
import sun.tools.javap.InnerClassData;
import sun.tools.javap.MethodData;
import sun.tools.javap.RuntimeConstants;
import sun.tools.javap.Tables;

public class ClassData
implements RuntimeConstants {
    private int magic;
    private int minor_version;
    private int major_version;
    private int cpool_count;
    private Object[] cpool;
    private int access;
    private int this_class = 0;
    private int super_class;
    private int interfaces_count;
    private int[] interfaces = new int[0];
    private int fields_count;
    private FieldData[] fields;
    private int methods_count;
    private MethodData[] methods;
    private InnerClassData[] innerClasses;
    private int attributes_count;
    private AttrData[] attrs;
    private String classname;
    private String superclassname;
    private int source_cpx = 0;
    private byte[] tags;
    private Hashtable indexHashAscii = new Hashtable();
    private String pkgPrefix = "";
    private int pkgPrefixLen = 0;
    static final String hexString = "0123456789ABCDEF";
    public static char[] hexTable = "0123456789ABCDEF".toCharArray();

    public int getCpoolCount() {
        return this.cpool_count;
    }

    public int getMajor_version() {
        return this.minor_version;
    }

    public int getMinor_version() {
        return this.minor_version;
    }

    public int getthis_cpx() {
        return this.this_class;
    }

    public boolean isClass() {
        return (this.access & 0x200) == 0;
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public boolean isSuperSet() {
        return (this.access & 0x20) != 0;
    }

    public byte getTag(int n) {
        try {
            return this.tags[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 100;
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        this.magic = dataInputStream.readInt();
        if (this.magic != -889275714) {
            throw new ClassFormatError("wrong magic: " + ClassData.toHex(this.magic) + ", expected " + ClassData.toHex(-889275714));
        }
        this.minor_version = dataInputStream.readShort();
        this.major_version = dataInputStream.readShort();
        if (this.major_version != 45) {
            // empty if block
        }
        this.readCP(dataInputStream);
        this.access = dataInputStream.readUnsignedShort();
        this.this_class = dataInputStream.readUnsignedShort();
        this.super_class = dataInputStream.readUnsignedShort();
        this.interfaces_count = dataInputStream.readUnsignedShort();
        if (this.interfaces_count > 0) {
            this.interfaces = new int[this.interfaces_count];
        }
        for (n = 0; n < this.interfaces_count; ++n) {
            this.interfaces[n] = dataInputStream.readShort();
        }
        this.readFields(dataInputStream);
        this.readMethods(dataInputStream);
        this.attributes_count = dataInputStream.readUnsignedShort();
        this.attrs = new AttrData[this.attributes_count];
        for (n = 0; n < this.attributes_count; ++n) {
            AttrData attrData;
            int n2 = dataInputStream.readUnsignedShort();
            if (this.getTag(n2) == 1 && this.getString(n2).equals("SourceFile")) {
                if (dataInputStream.readInt() != 2) {
                    throw new ClassFormatError("invalid attr length");
                }
                this.source_cpx = dataInputStream.readUnsignedShort();
                attrData = new AttrData(this);
                attrData.read(n2);
                this.attrs[n] = attrData;
                continue;
            }
            if (this.getTag(n2) == 1 && this.getString(n2).equals("InnerClasses")) {
                int n3 = dataInputStream.readInt();
                int n4 = dataInputStream.readUnsignedShort();
                if (2 + n4 * 8 != n3) {
                    throw new ClassFormatError("invalid attr length");
                }
                this.innerClasses = new InnerClassData[n4];
                for (int i = 0; i < n4; ++i) {
                    InnerClassData innerClassData = new InnerClassData(this);
                    innerClassData.read(dataInputStream);
                    this.innerClasses[i] = innerClassData;
                }
                AttrData attrData2 = new AttrData(this);
                attrData2.read(n2);
                this.attrs[n] = attrData2;
                continue;
            }
            attrData = new AttrData(this);
            attrData.read(n2, dataInputStream);
            this.attrs[n] = attrData;
        }
        dataInputStream.close();
    }

    void readCP(DataInputStream dataInputStream) throws IOException {
        this.cpool_count = dataInputStream.readUnsignedShort();
        this.tags = new byte[this.cpool_count];
        this.cpool = new Object[this.cpool_count];
        block9: for (int i = 1; i < this.cpool_count; ++i) {
            byte by;
            this.tags[i] = by = dataInputStream.readByte();
            switch (this.tags[i]) {
                case 1: {
                    String string = dataInputStream.readUTF();
                    this.cpool[i] = string;
                    this.indexHashAscii.put(this.cpool[i], new Integer(i));
                    continue block9;
                }
                case 3: {
                    this.cpool[i] = new Integer(dataInputStream.readInt());
                    continue block9;
                }
                case 4: {
                    this.cpool[i] = new Float(dataInputStream.readFloat());
                    continue block9;
                }
                case 5: {
                    this.cpool[i++] = new Long(dataInputStream.readLong());
                    continue block9;
                }
                case 6: {
                    this.cpool[i++] = new Double(dataInputStream.readDouble());
                    continue block9;
                }
                case 7: 
                case 8: {
                    this.cpool[i] = new CPX(dataInputStream.readUnsignedShort());
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.cpool[i] = new CPX2(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                    continue block9;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + this.tags[i]);
                }
            }
        }
    }

    protected void readFields(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        this.fields = new FieldData[n];
        for (int i = 0; i < n; ++i) {
            FieldData fieldData = new FieldData(this);
            fieldData.read(dataInputStream);
            this.fields[i] = fieldData;
        }
    }

    protected void readMethods(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        this.methods = new MethodData[n];
        for (int i = 0; i < n; ++i) {
            MethodData methodData = new MethodData(this);
            methodData.read(dataInputStream);
            this.methods[i] = methodData;
        }
    }

    public ClassData(InputStream inputStream) {
        try {
            this.read(new DataInputStream(inputStream));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error("cant read file");
        }
        catch (Error error) {
            error.printStackTrace();
            this.error("fatal error");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.error("fatal exception");
        }
    }

    public Object getCpoolEntryobj(int n) {
        return this.cpool[n];
    }

    public String getClassName() {
        int n;
        String string = null;
        if (this.this_class == 0) {
            return string;
        }
        try {
            if (this.tags[this.this_class] != 7) {
                return string;
            }
            n = ((CPX)this.cpool[this.this_class]).cpx;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return string;
        }
        catch (Throwable throwable) {
            return string;
        }
        try {
            return (String)this.cpool[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        catch (ClassCastException classCastException) {}
        finally {
            return string;
        }
    }

    public String getPkgName() {
        String string = this.getClassName(this.this_class);
        this.pkgPrefixLen = string.lastIndexOf("/") + 1;
        if (this.pkgPrefixLen != 0) {
            this.pkgPrefix = string.substring(0, this.pkgPrefixLen);
            return "package  " + this.pkgPrefix.substring(0, this.pkgPrefixLen - 1) + ";\n";
        }
        return null;
    }

    public String getSourceName() {
        return this.getName(this.source_cpx);
    }

    public String getSuperClassName() {
        int n;
        String string = null;
        if (this.super_class == 0) {
            return string;
        }
        try {
            if (this.tags[this.super_class] != 7) {
                return string;
            }
            n = ((CPX)this.cpool[this.super_class]).cpx;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return string;
        }
        catch (Throwable throwable) {
            return string;
        }
        try {
            return (String)this.cpool[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        catch (ClassCastException classCastException) {}
        finally {
            return string;
        }
    }

    public String[] getAccess() {
        Vector<String> vector = new Vector<String>();
        if ((this.access & 1) != 0) {
            vector.addElement("public");
        }
        if ((this.access & 0x10) != 0) {
            vector.addElement("final");
        }
        if ((this.access & 0x400) != 0) {
            vector.addElement("abstract");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] getSuperInterfaces() {
        String[] stringArray = new String[this.interfaces.length];
        int n = -1;
        for (int i = 0; i < this.interfaces.length; ++i) {
            n = ((CPX)this.cpool[this.interfaces[i]]).cpx;
            stringArray[i] = (String)this.cpool[n];
        }
        return stringArray;
    }

    public String StringTag(int n) {
        byte by = 0;
        String string = null;
        try {
            if (n == 0) {
                throw new IndexOutOfBoundsException();
            }
            by = this.tags[n];
            return this.TagString(by);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = "Incorrect CP index:" + n;
            return string;
        }
    }

    public String StringValue(int n) {
        Object object;
        byte by;
        if (n == 0) {
            return "#0";
        }
        String string = "";
        try {
            by = this.tags[n];
            object = this.cpool[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "<Incorrect CP index:" + n + ">";
        }
        if (object == null) {
            return "<NULL>";
        }
        switch (by) {
            case 1: {
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = (String)object;
                block19: for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    switch (c) {
                        case '\t': {
                            stringBuffer.append('\\').append('t');
                            continue block19;
                        }
                        case '\n': {
                            stringBuffer.append('\\').append('n');
                            continue block19;
                        }
                        case '\r': {
                            stringBuffer.append('\\').append('r');
                            continue block19;
                        }
                        case '\"': {
                            stringBuffer.append('\\').append('\"');
                            continue block19;
                        }
                        default: {
                            stringBuffer.append(c);
                        }
                    }
                }
                return stringBuffer.toString();
            }
            case 6: {
                Double d = (Double)object;
                String string3 = d.toString();
                return string3 + "d";
            }
            case 4: {
                Float f = (Float)object;
                String string4 = f.toString();
                return string4 + "f";
            }
            case 5: {
                Long l = (Long)object;
                return l.toString() + 'l';
            }
            case 3: {
                Integer n2 = (Integer)object;
                return n2.toString();
            }
            case 7: {
                return this.getShortClassName(n);
            }
            case 8: {
                return this.StringValue(((CPX)object).cpx);
            }
            case 9: 
            case 10: 
            case 11: {
                return this.javaName(this.getClassName(((CPX2)object).cpx1)) + "." + this.StringValue(((CPX2)object).cpx2);
            }
            case 12: {
                return this.getName(((CPX2)object).cpx1) + ":" + this.StringValue(((CPX2)object).cpx2);
            }
        }
        return "UnknownTag";
    }

    public String TagString(int n) {
        String string = Tables.tagName(n);
        if (string == null) {
            return "BOGUS_TAG:" + n;
        }
        return string;
    }

    public String getClassName(int n) {
        int n2;
        String string = "#" + n;
        if (n == 0) {
            return string;
        }
        try {
            if (this.tags[n] != 7) {
                return string;
            }
            n2 = ((CPX)this.cpool[n]).cpx;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return string;
        }
        catch (Throwable throwable) {
            return string;
        }
        string = "#" + n2;
        try {
            return (String)this.cpool[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        catch (ClassCastException classCastException) {}
        finally {
            return string;
        }
    }

    public String getName(int n) {
        try {
            return this.javaName((String)this.cpool[n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "<invalid constant pool index:" + n + ">";
        }
        catch (ClassCastException classCastException) {
            return "<invalid constant pool ref:" + n + ">";
        }
    }

    public String getShortClassName(int n) {
        String string = this.javaName(this.getClassName(n));
        this.pkgPrefixLen = string.lastIndexOf("/") + 1;
        if (this.pkgPrefixLen != 0) {
            this.pkgPrefix = string.substring(0, this.pkgPrefixLen);
            if (string.startsWith(this.pkgPrefix)) {
                return string.substring(this.pkgPrefixLen);
            }
        }
        return string;
    }

    public String getString(int n) {
        return n == 0 ? null : (String)this.cpool[n];
    }

    public String getStringValue(int n) {
        try {
            return (String)this.cpool[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "//invalid constant pool index:" + n;
        }
        catch (ClassCastException classCastException) {
            return "//invalid constant pool ref:" + n;
        }
    }

    static String toHex(int n) {
        int n2;
        for (n2 = 8; n2 > 0 && n >> (n2 - 1) * 4 == 0; --n2) {
        }
        return ClassData.toHex(n, n2);
    }

    static String toHex(long l) {
        int n;
        for (n = 16; n > 0 && l >> (n - 1) * 4 == 0L; --n) {
        }
        return ClassData.toHex(l, n);
    }

    static String toHex(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n - 1; i >= 0; --i) {
            stringBuffer.append(hexTable[(int)(l >> 4 * i) & 0xF]);
        }
        return "0x" + stringBuffer.toString();
    }

    public void error(String string) {
        System.err.println("ERROR:" + string);
    }

    public AttrData[] getAttributes() {
        return this.attrs;
    }

    public CPX2 getCpoolEntry(int n) {
        return (CPX2)this.cpool[n];
    }

    public FieldData[] getFields() {
        return this.fields;
    }

    public InnerClassData[] getInnerClasses() {
        return this.innerClasses;
    }

    public MethodData[] getMethods() {
        return this.methods;
    }

    public String javaName(String string) {
        block4: {
            if (string == null) {
                return "null";
            }
            int n = string.length();
            if (n == 0) {
                return "\"\"";
            }
            int n2 = 47;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!(n2 == 47 ? !Character.isJavaIdentifierStart(c) : c != '/' && !Character.isJavaIdentifierPart(c))) {
                    n2 = c;
                    continue;
                }
                break block4;
            }
            return string;
        }
        return "\"" + string + "\"";
    }
}

