/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmerrordialog.h"
#include "pmerrorflags.h"

#include <klocale.h>
#include <qlabel.h>
//#include <qlistbox.h>
#include <qtextedit.h>
#include <qstringlist.h>

#include <kconfig.h>


QSize PMErrorDialog::s_size = QSize( 150, 200 );

PMErrorDialog::PMErrorDialog( const QStringList& messages, int errorFlags,
                              QWidget* parent, const char* name )
      : KDialogBase( parent, name, true, i18n( "Messages" ),
                     Ok | Cancel, Cancel )
{
   QVBox* page = makeVBoxMainWidget( );
   QLabel* text = new QLabel( QString( "" ), ( QWidget* )page );

   
   m_pTextView = new QTextEdit( ( QWidget* )page );
   m_pTextView->setReadOnly( true );
   displayMessages( messages );

   if( errorFlags & PMEWarning )
   {
      if( errorFlags & PMEError )
         text->setText( i18n( "There were warnings and errors:" ) );
      else
         text->setText( i18n( "There were warnings:" ) );
   }
   else
      text->setText( i18n( "There were errors:" ) );
   
   setButtonOKText( i18n( "OK" ),
                    i18n( "Proceed" ),
                    i18n( "When clicking <b>Proceed</b>, the program\n"
                          "will try to proceed with the current action." ) );
   setButtonCancelText( i18n( "Cancel" ),
                        i18n( "Cancel" ),
                        i18n( "When clicking <b>Cancel<b>, the program\n"
                              "will cancel the current action." ) );
      
   if( errorFlags & PMEFatal )
      showButtonOK( false );
   else
      new QLabel( QString( "Still try to proceed?" ), ( QWidget* )page );

   resize( s_size );
}

void PMErrorDialog::displayMessages( const QStringList& messages )
{
   QStringList::ConstIterator it;
   QString text;

   text = "<qt>\n";
   
   for( it = messages.begin( ); it != messages.end( ); ++it )
      text += "<p>" + *it + "</p>\n";

   text += "</qt>";
   
   m_pTextView->setText( text );
}

void PMErrorDialog::saveConfig( KConfig* cfg )
{
   cfg->setGroup( "Appearance" );
   cfg->writeEntry( "ErrorDialogSize", s_size );
}

void PMErrorDialog::restoreConfig( KConfig* cfg )
{
   cfg->setGroup( "Appearance" );

   QSize defaultSize( 150, 200 );
   s_size = cfg->readSizeEntry( "ErrorDialogSize", &defaultSize );
}

void PMErrorDialog::resizeEvent( QResizeEvent* ev )
{
   s_size = ev->size( );
}
#include "pmerrordialog.moc"
