namespace Binge.Bits
{
	using System;
	using System.Collections;

	public class Namespace: Binge.Bits.Object
	{
		public Hashtable Classes, Interfaces, Enums;
		public ArrayList Using;
		public string Name;
		public bool Throttle;


		public enum ItemTypes
		{
			Interface,
			Class,
			Enum,
			Field,
			Property,
			Constructor,
			Destructor,
			Method
		}

		public Namespace (): this (true) {}

		public Namespace (bool init)
		{
			if (! init) return;

			Using = new ArrayList ();
			Name = String.Empty;
			Classes = new Hashtable ();
			Interfaces = new Hashtable ();
			Enums = new Hashtable ();
			Throttle = false;
		}

		public bool Contains (string name, ItemTypes t)
		{
			switch (t)
			{
				case ItemTypes.Interface:
					return Interfaces.ContainsKey (name);
				case ItemTypes.Class:
					return Classes.ContainsKey (name);
				case ItemTypes.Enum:
					return Enums.ContainsKey (name);
				default:
					return false;
			}
		}

		public object Get (string name, ItemTypes t)
		{
			switch (t)
			{
				case ItemTypes.Interface:
					return Interfaces[name];
				case ItemTypes.Class:
					return Classes[name];
				case ItemTypes.Enum:
					return Enums[name];
				default:
					return null;
			}
		}

		public override string ToString ()
		{
			return "Namespace";
		}
	}
}
