/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <kdebug.h>

#include "jsconsolepart.h"
#include "jsconsolepart.moc"

//
// KPart Implementation
//
namespace KJSEmbed {

JSConsolePart::JSConsolePart( QWidget *parent, const char *name )
    : KParts::ReadOnlyPart( parent, name )
{
    jsConsole = new JSConsoleWidget( parent, name );
    setWidget( jsConsole );
}

JSConsolePart::JSConsolePart( KJS::Interpreter *js, QWidget *parent, const char *name )
    : KParts::ReadOnlyPart( parent, name )
{
    jsConsole = new JSConsoleWidget( js, parent, name );
    setWidget( jsConsole );
}

JSConsolePart::~JSConsolePart()
{
}

bool JSConsolePart::openURL( const KURL &url )
{
    if ( url.protocol() == "javascript" ) {
	kdDebug() << "JSConsolePart: openURL '" << url.url() << "' is javascript" << endl;

	QString cmd = url.url();
	QString js( "javascript:" );
	cmd = cmd.replace( 0, js.length(), QString("") );

	kdDebug() << "JSConsolePart: JS command is '" << cmd << "'" << endl;
	return jsConsole->execute( cmd );
    }
    return false;
}

}; // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:
