/***************************************************************************
                            NodeFilter.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef NODEFILTER_H
#define NODEFILTER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Filters are objects that know how to "filter out" nodes. If an
 Iterator or <code> TreeWalker </code> is given a filter, before it
 returns the next node, it applies the filter. If the filter says to
 accept the node, the Iterator returns it; otherwise, the Iterator
 looks for the next node and pretends that the node that was
 rejected was not there.

  The DOM does not provide any filters. Filter is just an interface
 that users can implement to provide their own filters.

  Filters do not need to know how to iterate, nor do they need to
 know anything about the data structure that is being iterated. This
 makes it very easy to write filters, since the only thing they have
 to know how to do is evaluate a single node. One filter may be used
 with a number of different kinds of Iterators, encouraging code
 reuse.

 To create your own cutsom NodeFilter, define a subclass of
 CustomNodeFilter which overrides the -acceptNode method and assign
 an instance of it to the NodeFilter. For more details see the
 CustomNodeFilter class
 
 @short 
 Filters are objects that know how to "filter out" nodes.
*/
@class DOMNode;

@interface  NodeFilter : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;

/** 
 Test whether a specified node is visible in the logical view of
 a TreeWalker or NodeIterator. This function will be called by
 the implementation of TreeWalker and NodeIterator; it is not
 intended to be called directly from user code.

     
*/
- (short) acceptNode: (DOMNode*)n;
- (BOOL) isNull;
//- setCustomNodeFilter: (CustomNodeFilter*)custom;
//- (CustomNodeFilter*) customNodeFilter;
//+ (NodeFilter*) createCustom: (CustomNodeFilter*)custom;
+ (int) FILTER_ACCEPT;
+ (int) FILTER_REJECT;
+ (int) FILTER_SKIP;
+ (int) SHOW_ALL;
+ (int) SHOW_ELEMENT;
+ (int) SHOW_ATTRIBUTE;
+ (int) SHOW_TEXT;
+ (int) SHOW_CDATA_SECTION;
+ (int) SHOW_ENTITY_REFERENCE;
+ (int) SHOW_ENTITY;
+ (int) SHOW_PROCESSING_INSTRUCTION;
+ (int) SHOW_COMMENT;
+ (int) SHOW_DOCUMENT;
+ (int) SHOW_DOCUMENT_TYPE;
+ (int) SHOW_DOCUMENT_FRAGMENT;
+ (int) SHOW_NOTATION;
@end

#endif
