/***************************************************************************
                            KURLPixmapProvider.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KURLPIXMAPPROVIDER_H
#define KURLPIXMAPPROVIDER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KPixmapProvider.h>

/**

 Implementation of @ref KPixmapProvider

 Uses @ref -[KMimeType pixmapForURL] to resolve icons.

 Instatiate this class and supply it to the desired class, e.g.
 <pre>
 KHistoryCombo *combo = new KHistoryCombo( this );
 -[combo setPixmapProvider]( new KURLPixmapProvider );
 [...]
 </pre>

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short Resolves pixmaps for URLs.
*/
@class QPixmap; 

@interface KURLPixmapProvider : KPixmapProvider 

/** 
 Returns a pixmap for @p url with size @p size
 Uses @ref -[KMimeType pixmapForURL]
     
*/
- (QPixmap*) pixmapFor: (NSString *)url size: (int)size;
- (QPixmap*) pixmapFor: (NSString *)url ;
@end

#endif
