/***************************************************************************
                            Scheduler.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KIO.Scheduler manages io-slaves for the application.
 It also queues jobs and assigns the job to a slave when one
 becomes available.

 There are 3 possible ways for a job to get a slave:

 1) Direct.
 This is the default. When you create a job the
 KIO.Scheduler will be notified and will find either an existing
 slave that is idle or it will create a new slave for the job.

 Example:
    TransferJob job = KIO.get(KURL("http://www.kde.org"));

 2) Scheduled
 If you create a lot of jobs, you might want not want to have a
 slave for each job. If you schedule a job, a maximum number
 of slaves will be created. When more jobs arrive, they will be
 queued. When a slave is finished with a job, it will be assigned
 a job from the queue.

 Example:
 <pre>
    TransferJob job = KIO.get(KURL("http://www.kde.org"));
    KIO.Scheduler.scheduleJob(job);
 </pre>

 3) Connection Oriented
 For some operations it is important that multiple jobs use
 the same connection. This can only be ensured if all these jobs
 use the same slave.

 You can ask the scheduler to open a slave for connection oriented
 operations. You can then use the scheduler to assign jobs to this
 slave. The jobs will be queued and the slave will handle these jobs
 one after the other.

 Example:
 <pre>
    Slave slave = KIO.Scheduler.getConnectedSlave(
            KURL("pop3://bastian:password@mail.kde.org"));
    TransferJob job1 = KIO.get(
            KURL("pop3://bastian:password@mail.kde.org/msg1"));
    KIO.Scheduler.assignJobToSlave(slave, job1);
    TransferJob job2 = KIO.get(
            KURL("pop3://bastian:password@mail.kde.org/msg2"));
    KIO.Scheduler.assignJobToSlave(slave, job2);
    TransferJob job3 = KIO.get(
            KURL("pop3://bastian:password@mail.kde.org/msg3"));
    KIO.Scheduler.assignJobToSlave(slave, job3);

    // ... Wait for jobs to finish...

    KIO.Scheduler.disconnectSlave(slave);
 </pre>

 See {@link SchedulerSignals} for signals emitted by Scheduler.

 

 @short *
 The KIO::Scheduler manages io-slaves for the application.
*/
public class Scheduler extends QObject implements  DCOPObjectInterface {
	protected Scheduler(Class dummy){super((Class) null);}

	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native boolean connect( QObject sender, String signal, String member);
	public native void debug_info();
	public native boolean process( String fun, byte[] data, String replyType, byte[] replyData);
	public native ArrayList functions();
	public native void slotSlaveDied( Slave slave);
	public native void slotSlaveStatus( long pid, String protocol, String host, boolean connected);

/** 
 Register <code>job</code> with the scheduler. 
 The default is to create a new slave for the job if no slave
 is available. This can be changed by calling {@link scheduleJob}.
         
*/
	public static native void doJob( SimpleJob job);

/** 
 Calling ths function makes that <code>job</code> gets scheduled for later
 execution, if multiple jobs are registered it might wait for
 other jobs to finish.
         
*/
	public static native void scheduleJob( SimpleJob job);

/** 
 Stop the execution of a job.
         
*/
	public static native void cancelJob( SimpleJob job);

/** 
 Called when a job is done.
         
*/
	public static native void jobFinished( SimpleJob job, Slave slave);

/** 
 Puts a slave on notice. A next job may reuse this slave if it
 requests the same URL.

 A job can be put on hold after it has emit'ed its mimetype.
 Based on the mimetype, the program can give control to another
 component in the same process which can then resume the job
 by simply asking for the same URL again.
         
*/
	public static native void putSlaveOnHold( SimpleJob job, KURL url);

/** 
 Removes any slave that might have been put on hold. If a slave 
 was put on hold it will be killed.
         
*/
	public static native void removeSlaveOnHold();

/** 
 Send the slave that was put on hold back to KLauncher. This
 allows another process to take over the slave and resume the job
 the that was started.
         
*/
	public static native void publishSlaveOnHold();

/** 
 Requests a slave for use in connection-oriented mode.

*/
//	public static native Slave getConnectedSlave( KURL url, MetaData config);
	public static native Slave getConnectedSlave( KURL url);
	public static native boolean assignJobToSlave( Slave slave, SimpleJob job);
	public static native boolean disconnectSlave( Slave slave);

/** 
 Send the slave that was put on hold back to KLauncher. This
 allows another process to take over the slave and resume the job
 the that was started.

*/
	public static native void registerWindow( QWidget wid);

/** 
 Function to connect signals emitted by the scheduler.

*/
	public static native boolean connect( String signal, QObject receiver, String member);
	public static native boolean connect( QObject sender, String signal, QObject receiver, String member);
	public static native boolean disconnect( QObject sender, String signal, QObject receiver, String member);

/** 
 When true, the next job will check whether KLauncher has a slave 
 on hold that is suitable for the job.
         
*/
	public static native void checkSlaveOnHold( boolean b);
	protected native void setupSlave( Slave slave, KURL url, String protocol, String proxy, boolean newSlave, int config);
	protected native void setupSlave( Slave slave, KURL url, String protocol, String proxy, boolean newSlave);
//	protected native boolean startJobScheduled( ProtocolInfo protInfo);
	protected native boolean startJobDirect();
	private native void newScheduler();
	public Scheduler() {
		super((Class) null);
		newScheduler();
	}
	protected native void virtual_hook( int identifier, int data);
	protected native void startStep();
	protected native void slotCleanIdleSlaves();
	protected native void slotSlaveConnected();
	protected native void slotSlaveError( int error, String errorMsg);
	protected native void slotScheduleCoSlave();
	protected native void slotUnregisterWindow( QObject arg1);

 	// From DCOPObjectInterface
  /**
 Returns the object id of the DCOPObject.

*/
	public native String objId();

/**
 Renames a dcop object, if no other with the same name exists
 Use with care, all dcop signals are disconnected

*/
	public native boolean setObjId( String objId);


/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #process} but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
	public native boolean processDynamic( String fun, byte[] data, String replyType, byte[] replyData);

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #functions} but
 you still want to list some functions dynamically.
 Dynamically means that the methods may appear and vanish
 during runtime.

*/
	public native ArrayList functionsDynamic();

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #interfaces} but
 you still want to list some interfaces dynamically.
 Dynamically means that they may appear and vanish
 during runtime.

*/
	public native ArrayList interfacesDynamic();

/**
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
	public native ArrayList interfaces();


/**
 Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as
 arguments

*/
	public native void emitDCOPSignal( String signal, byte[] data);

/**
 Connects to a DCOP signal.

*/
	public native boolean connectDCOPSignal( String sender, String senderObj, String signal, String slot, boolean Volatile);

/**
 Disconnects a DCOP signal.

 A special case is when both <code>sender</code> & <code>signal</code> are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
	public native boolean disconnectDCOPSignal( String sender, String senderObj, String signal, String slot);

/**
 Returns the {@link DCOPClient} responsible for making the call.
 Only call this function while you are handling a DCOP call.

*/
	public native DCOPClient callingDcopClient();

/**

*/
	public native void setCallingDcopClient( DCOPClient arg1);

/**
 Checks whether an object with the given id is known in this process.

 {@link DCOPObjectProxy}

*/
	public static native boolean hasObject( String objId);

/**
 Try to find a dcop object with the given id.
 This function does not query the {@link DCOPObjectProxy}.

*/
	public static native DCOPObjectInterface find( String objId);

/**
 Tries to find an object using a partial object id.
 This function is used for multicasting a DCOP message to
 several objects inside a single process.

*/
//	public static native QPtrList<DCOPObject> match( String partialId);

/**
 Creates an object id for the QObject <code>obj.</code> This is done
 using the {@link QObject#name} function.

*/
	public static native String objectName( QObject obj);

}
