/***************************************************************************
                            KDirLister.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The dir lister deals with the kiojob used to list and update a directory
 and has signals for the user of this class (e.g. konqueror view or
 kdesktop) to create/destroy its items when asked.

 This class is independent from the graphical representation of the dir
 (icon container, tree view, ...) and it stores the items (as KFileItems).

 Typical usage :
 Create an instance.
 Connect to at least update, clear, newItem, and deleteItem.
 Call openURL - the signals will be called.
 Reuse the instance when opening a new url (openURL).
 Destroy the instance when not needed anymore (usually destructor).

 Advanced usage : call openURL with _keep = true to list directories
 without forgetting the ones previously read (e.g. for a tree view)

 See {@link KDirListerSignals} for signals emitted by KDirLister.

 

 @short Helper class for the kiojob used to list and update a directory.
 
*/
public class KDirLister extends QObject  {
	protected KDirLister(Class dummy){super((Class) null);}

	private native void newKDirLister( boolean _delayedMimeTypes);

/** 
 Create a directory lister.
   
*/
	public KDirLister( boolean _delayedMimeTypes) {
		super((Class) null);
		newKDirLister( _delayedMimeTypes);
	}
	private native void newKDirLister();
	public KDirLister() {
		super((Class) null);
		newKDirLister();
	}

/** 
 Destroy the directory lister.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Run the directory lister on the given url.

 This method causes KDirLister to emit _all_ the items of <code>_url</code>, in any case.
 Depending on <code>_keep</code> either clear() or clear( const KURL & ) will be
 emitted first.

 The {@link #newItems} signal may be emitted more than once to supply you
 with KFileItems, up until the signal {@link #completed} is emitted
 (and {@link #isFinished} returns true).
   
*/
	public native boolean openURL( KURL _url, boolean _keep, boolean _reload);
	public native boolean openURL( KURL _url);

/** 
 Stop listing all directories currently being listed.

 Emits {@link #canceled} if there was at least one job running.
 Emits {@link #canceled} for each stopped job if
 there are at least two dirctories being watched by KDirLister.
   
*/
	public native void stop();

/** 
 Stop listing the given directory.

 Emits {@link #canceled} if the killed job was the last running one.
 Emits {@link #canceled} for the killed job if
 there are at least two directories being watched by KDirLister.
 No signal is emitted if there was no job running for <code>_url.</code>

*/
	public native void stop( KURL _url);

/** 

*/
	public native boolean autoUpdate();

/** 
 Enable/disable automatic directory updating, when a directory changes
 (using KDirWatch).
   
*/
	public native void setAutoUpdate( boolean enable);

/** 
 Error handling.
   
*/
	public native boolean autoErrorHandlingEnabled();
	public native void setAutoErrorHandlingEnabled( boolean enable, QWidget parent);

/** 

*/
	public native boolean showingDotFiles();

/** 
 Changes the "is viewing dot files" setting.
 Calls {@link #updateDirectory} if setting changed
   
*/
	public native void setShowingDotFiles( boolean _showDotFiles);

/** 

*/
	public native boolean dirOnlyMode();

/** 
 Call this with <code>dirsOnly</code> == true to list only directories
   
*/
	public native void setDirOnlyMode( boolean dirsOnly);

/** 

*/
	public native KURL url();

/** 
 actually emit the changes made with setShowingDotFiles, setDirOnlyMode,
 setNameFilter and setMimeFilter.
   
*/
	public native void emitChanges();

/** 
 Update the directory <code>_dir.</code> This method causes KDirLister to _only_ emit
 the items of <code>_dir</code> that actually changed compared to the current state in the
 cache and updates the cache.

 The current implementation calls updateDirectory automatically for
 local files, using KDirWatch (if autoUpdate() is true), but it might be
 useful to force an update manually.

*/
	public native void updateDirectory( KURL _dir);

/** 
 Returns true if no io operation is currently in progress.
   
*/
	public native boolean isFinished();

/** 

*/
	public native KFileItem rootItem();

/** 
 Find an item by its URL

*/
	public native KFileItem findByURL( KURL _url);
	public native KFileItem find( KURL _url);

/** 
 Find an item by its name

*/
	public native KFileItem findByName( String name);

/** 
 Set a name filter to only list items matching this name, e.g. ".cpp".

 You can set more than one filter by separating them with whitespace, e.g
 ".cpp .h".
 Call setNameFilter( String.null ) to disable filtering.
 Note: the direcory is not automatically reloaded.

*/
	public native void setNameFilter( String arg1);

/** 

*/
	public native String nameFilter();

/** 
 Set mime-based filter to only list items matching the given mimetypes

 NOTE: setting the filter does not automatically reload direcory.
 Also calling this function will not affect any named filter already set.

*/
	public native void setMimeFilter( String[] arg1);

/** 
 Filtering should be done with KFileFilter. This will be implemented in a later
 revision of KDirLister. This method may be removed then.

 Set mime-based exclude filter to only list items not matching the given mimetypes

 NOTE: setting the filter does not automatically reload direcory.
 Also calling this function will not affect any named filter already set.

   
*/
	public native void setMimeExcludeFilter( String[] arg1);

/** 
 Clears the mime based filter.

*/
	public native void clearMimeFilter();

/** 

*/
	public native ArrayList mimeFilters();

/** 

*/
	public native boolean matchesFilter( String name);

/** 

*/
	public native boolean matchesMimeFilter( String mime);

/** 
 Pass the main window this object is associated with
 this is used for caching authentication data

*/
	public native void setMainWindow( QWidget window);

/** 
 Returns the main window associated with this object.

*/
	public native QWidget mainWindow();

/** 
 Returns the items listed for the current {@link #url}.
 This method will NOT start listing a directory, you should only call
 this when receiving the {@link #finished} signal.

 The items in the {@link KFileItemList} are references to the items used
 by KDirLister, so e.g. an item gets destroyed when the {@link #deleteItem}
 signal is emitted.

*/
	public native ArrayList items( int which);

/** 
 Returns the items listed for the given <code>dir.</code>
 This method will NOT start listing <code>dir</code>, you should only call
 this when receiving the {@link #finished} signal.

 The items in the {@link KFileItemList} are references to the items used
 by KDirLister, so e.g. an item gets destroyed when the {@link #deleteItem}
 signal is emitted.

*/
	public native ArrayList itemsForDir( KURL dir, int which);

/** 
 Called for every new item before emitting {@link #newItems}.

*/
	protected native boolean matchesFilter( KFileItem arg1);
	protected native boolean matchesMimeFilter( KFileItem arg1);

/** 
 Called by the public matchesFilter/matchesMimeFilter to do the
 actual filtering. Those methods may be reimplemented to customize
 filtering.
   
*/
//	protected native boolean doNameFilter( String name, QPtrList<QRegExp>* filters);
	protected native boolean doMimeFilter( String mime, String[] filters);

/** 

   
*/
	protected native boolean doMimeExcludeFilter( String mimeExclude, String[] filters);

/** 
 Checks if an url is malformed or not and displays an error message
 if it is and autoErrorHandling is set to true.

*/
	protected native boolean validURL( KURL arg1);

/**  Reimplement to customize error handling 
*/
	protected native void handleError( Job arg1);
	protected native void virtual_hook( int identifier, int data);
	public static final int AllItems = 0;
	public static final int FilteredItems = 1;
	public static final int NONE = 0;
	public static final int NAME_FILTER = 1;
	public static final int MIME_FILTER = 2;
	public static final int DOT_FILES = 4;
	public static final int DIR_ONLY_MODE = 8;
}
