/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmtranslate.h"
#include "pmtranslateedit.h"

#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"
#include "pmtranslatecontrolpoint.h"

#include <kdebug.h>
#include "pmglobals.h"

#include <klocale.h>

const PMVector moveDefault = PMVector( 0.0, 0.0, 0.0 );

PMTranslate::PMTranslate( )
      : Base( )
{
}

PMTranslate::~PMTranslate( )
{
}

QString PMTranslate::description( ) const
{
   return i18n( "translate" );
}

void PMTranslate::serialize( PMOutputDevice& dev ) const
{
   QString vector;
   QTextStream str( &vector, IO_WriteOnly );
   int i;
   bool z[3];
   
   for( i = 0; i < 3; i++ )
      z[i] = approxZero( m_move[i] );
   if( !z[0] && z[1] && z[2] )
   {
      str << "x*";
      i = 0;
   }
   else if( z[0] && !z[1] && z[2] )
   {
      str << "y*";
      i = 1;
   }
   else if( z[0] && z[1] && !z[2] )
   {
      str << "z*";
      i = 2;
   }

   if( i < 3 )
   {
      if( m_move[i] > 0 )
         str << m_move[i];
      else
         str << "(" << m_move[i] << ")";
   }
   else
   {
      str << '<';
      for( i = 0; i < 3; i++ )
      {
         if( i > 0 )
            str << ", ";
         str << m_move[i];
      }
      str << '>';
   }
   
   dev.writeLine( "translate " + vector );
}

void PMTranslate::serialize( QDomElement& e, QDomDocument& /*doc*/ ) const
{
   e.setAttribute( "value", m_move.serializeXML( ) );
}

void PMTranslate::readAttributes( const PMXMLHelper& h )
{
   m_move = h.vectorAttribute( "value", moveDefault );
}

bool PMTranslate::isA( PMObjectType t ) const
{
   if( t == PMTTranslate )
      return true;
   return Base::isA( t );
}

void PMTranslate::setTranslation( const PMVector& p )
{
   if( p != m_move )
   {
      if( m_pMemento )
      {
         m_pMemento->addData( PMTTranslate, PMTranslationID, m_move );
         m_pMemento->setViewStructureChanged( );
      }
      m_move = p;
      m_move.resize( 3 );
   }
}

PMDialogEditBase* PMTranslate::editWidget( QWidget* parent ) const
{
   return new PMTranslateEdit( parent );
}

void PMTranslate::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTTranslate )
      {
         switch( data->valueID( ) )
         {
            case PMTranslationID:
               setTranslation( data->vectorData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMTranslate::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}

PMMatrix PMTranslate::transformationMatrix( ) const
{
   return PMMatrix::translation( m_move[0], m_move[1], m_move[2] );
}

void PMTranslate::controlPoints( PMControlPointList& list )
{
   list.append( new PMTranslateControlPoint( m_move, PMTranslationID ) );
}

void PMTranslate::controlPointsChanged( PMControlPointList& list )
{
   PMControlPoint* p;

   for( p = list.first( ); p; p = list.next( ) )
   {
      if( p->changed( ) )
      {
         switch( p->id( ) )
         {
            case PMTranslationID:
               setTranslation( ( ( PMTranslateControlPoint* ) p )->translation( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMTranslate::controlPointsChanged\n";
               break;
         }
      }
   }
}
