/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    private StepPattern[] m_patterns;

    public void fixupVariables(Vector vector, int n2) {
        int n3 = 0;
        while (n3 < this.m_patterns.length) {
            this.m_patterns[n3].fixupVariables(vector, n2);
            ++n3;
        }
    }

    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_patterns) {
            int n2 = this.m_patterns.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.m_patterns[n3].canTraverseOutsideSubtree()) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] stepPatternArray) {
        this.m_patterns = stepPatternArray;
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        XObject xObject = null;
        int n2 = this.m_patterns.length;
        int n3 = 0;
        while (n3 < n2) {
            XObject xObject2 = this.m_patterns[n3].execute(xPathContext);
            if (xObject2 != NodeTest.SCORE_NONE) {
                if (null == xObject) {
                    xObject = xObject2;
                } else if (xObject2.num() > xObject.num()) {
                    xObject = xObject2;
                }
            }
            ++n3;
        }
        if (null == xObject) {
            xObject = NodeTest.SCORE_NONE;
        }
        return xObject;
    }
}

