/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Method;

public class PropertyDescriptor
extends FeatureDescriptor {
    private Class propertyType;
    private Method readMethod;
    private Method writeMethod;
    private boolean bound;
    private boolean constrained;
    private Class propertyEditorClass;

    public PropertyDescriptor(String string, Class clazz) throws IntrospectionException {
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name");
        }
        this.setName(string);
        String string2 = PropertyDescriptor.capitalize(string);
        try {
            this.readMethod = Introspector.findMethod(clazz, "is" + string2, 0);
        }
        catch (Exception exception) {
            this.readMethod = Introspector.findMethod(clazz, "get" + string2, 0);
        }
        Class[] classArray = new Class[]{this.readMethod.getReturnType()};
        this.writeMethod = Introspector.findMethod(clazz, "set" + string2, 1, classArray);
        this.propertyType = this.findPropertyType(this.readMethod, this.writeMethod);
    }

    public PropertyDescriptor(String string, Class clazz, String string2, String string3) throws IntrospectionException {
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name");
        }
        this.setName(string);
        this.readMethod = Introspector.findMethod(clazz, string2, 0);
        if (this.readMethod != null) {
            Class[] classArray = new Class[]{this.readMethod.getReturnType()};
            this.writeMethod = Introspector.findMethod(clazz, string3, 1, classArray);
        } else {
            this.writeMethod = Introspector.findMethod(clazz, string3, 1);
        }
        this.propertyType = this.findPropertyType(this.readMethod, this.writeMethod);
    }

    public PropertyDescriptor(String string, Method method, Method method2) throws IntrospectionException {
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name");
        }
        this.setName(string);
        this.readMethod = method;
        this.writeMethod = method2;
        this.propertyType = this.findPropertyType(this.readMethod, this.writeMethod);
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public void setReadMethod(Method method) throws IntrospectionException {
        this.readMethod = method;
        this.propertyType = this.findPropertyType(this.readMethod, this.writeMethod);
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public void setWriteMethod(Method method) throws IntrospectionException {
        this.writeMethod = method;
        this.propertyType = this.findPropertyType(this.readMethod, this.writeMethod);
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bl2) {
        this.bound = bl2;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean bl2) {
        this.constrained = bl2;
    }

    public void setPropertyEditorClass(Class clazz) {
        this.propertyEditorClass = clazz;
    }

    public Class getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object;
            Method method = propertyDescriptor.getReadMethod();
            Method method2 = propertyDescriptor.getWriteMethod();
            if (!this.compareMethods(this.readMethod, method)) {
                return false;
            }
            if (!this.compareMethods(this.writeMethod, method2)) {
                return false;
            }
            if (this.propertyType == propertyDescriptor.getPropertyType() && this.propertyEditorClass == propertyDescriptor.getPropertyEditorClass() && this.bound == propertyDescriptor.isBound() && this.constrained == propertyDescriptor.isConstrained()) {
                return true;
            }
        }
        return false;
    }

    boolean compareMethods(Method method, Method method2) {
        if (method == null != (method2 == null)) {
            return false;
        }
        return method == null || method2 == null || method.equals(method2);
    }

    PropertyDescriptor(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        super(propertyDescriptor, propertyDescriptor2);
        Method method = propertyDescriptor.readMethod;
        Method method2 = propertyDescriptor2.readMethod;
        this.readMethod = method;
        if (method2 != null) {
            this.readMethod = method2;
        }
        if (method != null && method2 != null && method.getDeclaringClass() == method2.getDeclaringClass() && method.getReturnType() == Boolean.TYPE && method2.getReturnType() == Boolean.TYPE && method.getName().indexOf("is") == 0 && method2.getName().indexOf("get") == 0) {
            this.readMethod = method;
        }
        this.writeMethod = propertyDescriptor.writeMethod;
        if (propertyDescriptor2.writeMethod != null) {
            this.writeMethod = propertyDescriptor2.writeMethod;
        }
        this.propertyEditorClass = propertyDescriptor.propertyEditorClass;
        if (propertyDescriptor2.propertyEditorClass != null) {
            this.propertyEditorClass = propertyDescriptor2.propertyEditorClass;
        }
        this.bound = propertyDescriptor.bound | propertyDescriptor2.bound;
        this.constrained = propertyDescriptor.constrained | propertyDescriptor2.constrained;
        try {
            this.propertyType = this.findPropertyType(this.readMethod, this.writeMethod);
        }
        catch (IntrospectionException introspectionException) {
            throw new Error("PropertyDescriptor: internal error while merging PDs: " + introspectionException.getMessage());
        }
    }

    PropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        super(propertyDescriptor);
        this.readMethod = propertyDescriptor.readMethod;
        this.writeMethod = propertyDescriptor.writeMethod;
        this.propertyEditorClass = propertyDescriptor.propertyEditorClass;
        this.bound = propertyDescriptor.bound;
        this.constrained = propertyDescriptor.constrained;
        this.propertyType = propertyDescriptor.propertyType;
    }

    private Class findPropertyType(Method method, Method method2) throws IntrospectionException {
        Class clazz = null;
        if (method != null) {
            if (method.getParameterTypes().length != 0) {
                throw new IntrospectionException("bad read method arg count");
            }
            clazz = method.getReturnType();
            if (clazz == Void.TYPE) {
                throw new IntrospectionException("read method " + method.getName() + " returns void");
            }
        }
        if (method2 != null) {
            Class[] classArray = method2.getParameterTypes();
            if (classArray.length != 1) {
                throw new IntrospectionException("bad write method arg count");
            }
            if (clazz != null && clazz != classArray[0]) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            clazz = classArray[0];
        }
        return clazz;
    }

    static String capitalize(String string) {
        if (string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }
}

