.TH XvQueryAdaptors 3X  __vendorversion__
.\" $XFree86: xc/doc/man/Xv/XvQueryAdaptors.man,v 1.5 2001/01/27 18:20:36 dawes Exp $
.SH Name
XvQueryAdaptors \- return adaptor information for a screen
.\"
.SH Syntax
.B #include <X11/extensions/Xvlib.h>
.br
.sp 1l
.B XvQueryAdaptors(\fIdpy, win, p_num_adaptors, pp_adaptor_info\fR)
.sp 1l 
\fBDisplay \fI*dpy;\fR
.br
\fBDrawable \fI draw;\fR
.br
\fBint \fI*p_num_adaptors\fR;
.br
\fBXvAdaptorInfo \fI**pp_adaptor_info\fR;
.br
.\"
.SH Arguments
.\"
.IP \fIdpy\fR 8
Specifies the display screen on which the
Xv Server is to accept requests from Xv clients.  If the
display option is not specified, Xv uses the display screen
specified by your DISPLAY environment variable.  The display
option has the format hostname:number.  Using two colons
(::) instead of one (:) indicates that DECnet is to be used
for transport.
.IP \fIdraw\fR 8
Specifies a drawable of the screen for which the adaptor 
information is desired.
.IP \fIp_num_adaptors\fR 8
A pointer to where the numer of adaptors for the specified screen 
is returned.
.IP \fIpp_adaptor_info\fR 8
A pointer to where the list of returned adaptor information is
returned.
.\"
.SH Description
.\"
XvQueryAdaptors(3X) returns an video adaptor information for
the screen of the specified drawable.  The XvAdaptorInfo structure
has the following organization:
.EX

     typedef struct {
       XvPortID base_id;
       unsigned long num_ports;
       char type;
       char *name;
       unsigned long num_formats;
       XvFormat *formats;
       unsigned long num_adaptors;
     } XvAdaptorInfo;

.EE
.IP \fIbase_id\fR 8
The resource ID of the first adaptor port.
.IP \fInum_ports\fR 8
The number of ports supported by the adaptor.
.IP \fItype\fR 8
A bit mask with the value XvInputMask asserted if the adaptor supports video
input, and value XvOutputMask asserted if the adaptor supports video output.
.IP \fIname\fR 8
A vendor specific name that identifies the adaptor.
.IP \fInum_formats\fR 8
The number of depth/visual id formats supported by the adaptor.
.IP \fIformats\fR 8
A pointer to an array of XvFormat structures.
.PP
The XvFormat structure has the following organization:
.EX

     typedef struct {
       char depth;
       unsigned long visual_id;
     } XvFormat;

.EE
.IP \fIdepth\fR 8
A drawable depth supported by the adaptor.
.IP \fIvisual_id\fR 8
A visual-id supported for the given depth by the adaptor.
.\"
.SH Returned Values
.IP [Success] 8
Returns True if XvQueryAdaptors(3X) completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if XvQueryAdaptors(3X) failed to allocate memory to process
the request.
.SH Diagnostics
.IP [Drawable] 8
Returned if the requested drawable does not exist.
.SH See Also
XvFreeAdaptorInfo(3X)
.\"
