/*
 * newsscroller.h
 *
 * Copyright (c) 2000 Frerich Raabe <raabe@kde.org>
 * Copyright (c) 2001 Malte Starostik <malte.starostik@t-online.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef NEWSSCROLLER_H
#define NEWSSCROLLER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qcolor.h>
#include <qframe.h>
#include <qtimer.h>
#include <qlist.h>
#include <qpixmap.h>

#include <kurl.h>

class Article;
class Headline;

class NewsScroller : public QFrame
{
	Q_OBJECT

	public:
		enum Direction {Left = 0, Right, Up, Down};
		NewsScroller(QWidget *, uint = 80, const char * = 0);

		uint speed() const { return _speed; }
		QColor foregroundColor() const { return _foregroundColor; }
		QColor backgroundColor() const { return _backgroundColor; }
		QColor highlightedColor() const { return _highlightedColor; }
		Direction direction() const { return _direction; }
		virtual QSizePolicy sizePolicy() const;
		virtual void setFont(const QFont &);

	public slots:
		void clear();
		void addHeadline(Article *);
		void setSpeed(uint);
		void setDirection(const Direction);
		virtual void setForegroundColor(const QColor &);
		virtual void setBackgroundColor(const QColor &);
		void setHighlightedColor(const QColor &);
		void setEndless(bool);
		void setUnderlineHighlighted(bool);

	signals:
		void contextMenu();

	protected:
		virtual void mousePressEvent(QMouseEvent *);
		virtual void mouseReleaseEvent(QMouseEvent *);
		virtual void mouseMoveEvent(QMouseEvent *);
		virtual void wheelEvent(QWheelEvent *);
		virtual void leaveEvent(QEvent *);
		virtual void drawContents(QPainter *);

	protected slots:
		void slotScrollText(int = 1);
		void slotTimeout();

	private:
		void reset(bool bRepaint = true, bool bSeparatorOnly = false);
		int scrollWidth() const;
		int scrollHeight() const;
		bool updateActive(const QPoint &);

	private:
		QTimer *_scrollTimer;
		QColor _foregroundColor, _backgroundColor, _highlightedColor;
		uint _speed;
		Direction _direction;
		bool _endless, _underlineHighlighted, _mouseDrag;
		QList<Headline> _headlines;
		Headline *_activeHeadline;
		QPixmap _separator;
		int _offset, _dragStart, _temp;
		QString _tempHeadline;
};

#endif // NEWSSCROLLER_H
