// tbuddylist.h
//
// Kit AIM client
//
// For copyright and license, see accompanying documentation

#ifndef TBUDDYLIST_H
#define TBUDDYLIST_H

#include <qstring.h>

typedef struct TBuddy
{
	QString name;
	int group;
	int status;
	int userClass;
	int signonTime;
	int idleTime;
	int evil;

	TBuddy *prev;
	TBuddy *next;
};

typedef struct TBuddyGroup
{
	QString name;

	TBuddyGroup *prev;
	TBuddyGroup *next;
};

class TBuddyList
{
	public:
		TBuddyList();
		TBuddyList(const TBuddyList &);
		TBuddyList operator=(const TBuddyList &);
		~TBuddyList();

		int add(const TBuddy *);
		int del(int num);
		int del(const QString &name);
		QString getName(int num) const;
		int getNum(const QString &name) const;
		int getGroup(int num) const;
		int getStatus(int num) const;
		int get(TBuddy *, int num) const;
		int get(TBuddy *, const QString &name) const;
		inline int getCount(void) const {return count;};

		int setStatus(int num, int status);
		int setUserClass(int num, int userClass);
		int setSignonTime(int num, int time);
		int setIdleTime(int num, int time);
		int setEvil(int num, int evil);

		int addGroup(const QString &name);
		int delGroup(int num);
		int delGroup(const QString &name);
		int renameGroup(const QString &oldname, const QString &newname);
		QString getNameGroup(int num) const;
		int getNumGroup(const QString &name) const;
		inline int getCountGroup(void) const {return countG;};

		void reset(void);
	private:
		TBuddy *getByNum(int) const;
		TBuddyGroup *getByNumG(int) const;

		TBuddy *head;
		TBuddy *tail;
		int count;

		TBuddyGroup *headG;
		TBuddyGroup *tailG;
		int countG;
};

#endif
