#include <klocale.h>
#include <qstring.h>
#include <qlayout.h>
#include <qframe.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qfont.h>
#include <kseparator.h>

#include <assert.h>

#include "krfbconnection.h"
#include "kvncoptionsdlg.h"
#include "kvncconnectdlg.h"

#include "kvncconnectdlg.moc"

KVNCConnectDlg::KVNCConnectDlg( KRFBConnection *con,
				QWidget *parent, const char *name )
  : KDialogBase( Plain,
		 i18n( "Connect to VNC server..." ),
		 Help|Ok|Cancel|User1, Ok,
		 parent, name, true, true,
		 i18n( "O&ptions..." ) )
{
  assert( con );
  this->con = con;

  setHelp( "kvnc/index.html", QString::null );

  QFrame *frame = plainPage();
  QVBoxLayout *outer = new QVBoxLayout( frame, marginHint(), spacingHint() );

  //
  // Title block
  //
  QLabel *titleLabel = new QLabel( i18n( "Connect to VNC server" ), 
				   frame, "titleLabel" );
  QFont titleFont = titleLabel->font();
  titleFont.setBold( true );
  titleLabel->setFont( titleFont );
  KSeparator *titleSep = new KSeparator( frame );
  titleSep->setFrameStyle( QFrame::HLine|QFrame::Plain );
  outer->addWidget( titleLabel );
  outer->addWidget( titleSep );

  //
  // Main block
  //
  QGridLayout *inner = new QGridLayout( 2, 2, spacingHint() );

  QLabel *label = new QLabel( i18n("&Host Name:"), 
			      frame , "hostLabel");
  hostNameCombo = new QComboBox( true, frame );
  hostNameCombo->setInsertionPolicy( QComboBox::AtTop );
  hostNameCombo->setMaxCount( 10 );
  hostNameCombo->insertItem( "localhost" );
  label->setBuddy( hostNameCombo );
  hostNameCombo->setFocus();

  inner->addWidget( label, 0, 0 );
  inner->addWidget( hostNameCombo, 0, 1 );

  QLabel *label1 = new QLabel( i18n("&Display Number:"), 
			       frame, "displayNumber" );
  displayNumberEdit = new QSpinBox( frame );
  label1->setBuddy( displayNumberEdit );

  inner->addWidget( label1, 1, 0 );
  inner->addWidget( displayNumberEdit, 1, 1 );

  //  if ( viewer->display() != -1 ) {
  //    displayNumberEdit->setValue( viewer->display() );
    displayNumberEdit->setValue( 1 );
    //  }

  inner->setColStretch( 0, 0 );
  inner->setColStretch( 1, 15 );
  outer->addLayout( inner );
  outer->addStretch( 0 );
  outer->activate();
}


void KVNCConnectDlg::slotOk()
{
  int dis;
  //  viewer->setHost(hostNameCombo->currentText());
  QString temp = displayNumberEdit->text();
  if(temp.isEmpty())
    dis = -1;
  else
    dis = temp.toUInt();    
  //  viewer->setDisplay(dis);
  done(1);
}

void KVNCConnectDlg::slotUser1()
{
  KVNCOptionsDlg *wdg = new KVNCOptionsDlg( con->options(), this );
  wdg->exec();
  delete wdg;
}

