#ifndef VIEW_H
#define VIEW_H

#include <qevent.h>
#include <qlist.h>
#include <klistview.h>
#include <ktmainwindow.h>
#include <qrect.h>
#include <kdirlister.h>

class View;
class SafeListViewItem : public QCheckListItem, public PlayListItem
{
public:
	SafeListViewItem(QListView *parent, QListViewItem *after, const KURL &text);
	virtual ~SafeListViewItem();

protected:
	virtual void downloaded(int percent);
	virtual void modified();	
};

class List : public KListView
{
Q_OBJECT
friend class View;
public:
	List(View *parent);
	virtual ~List();
	QListViewItem *openGlobal(const KURL&, QListViewItem * =0);
	QListViewItem *addFile(const KURL&, bool play=false, QListViewItem * =0);

signals:
	void modified(void);
	
protected:
	virtual bool acceptDrag(QDropEvent *event) const;
	virtual void viewportPaintEvent(QPaintEvent *);
protected slots:
	virtual void dropEvent(QDropEvent *event, QListViewItem *after);
	void move(QList<QListViewItem> &item, QList<QListViewItem> &afterFirst, QList<QListViewItem> &afterNow);

};

class KFileDialog;
class KToggleAction;
class KToolBar;

class View : public KMainWindow
{
Q_OBJECT
public:
	View(SplitPlayList *mother);
	// load the SM playlist
	void init();
	virtual ~View();
	List *listView() const { return list; }
	QListViewItem *addFile(const KURL &u, bool play=false)
	{ return list->addFile(u, play); }
	

public slots:
	void deleteSelected();
	void addFiles();
	void addDirectory();
	void save();
	void saveAs();
	void open();
	void openNew();
	void clearView() { list->clear(); }

	
private slots:
	void setModified();
	void saveState();

	void listDone();
	
protected:
	void setupActions();
	void saveToURL(const KURL &);
	void setModified(bool);
	virtual void closeEvent(QCloseEvent*e);
	virtual void showEvent(QShowEvent *);
	virtual void hideEvent(QHideEvent *);
	
	void addDirectory(const KURL &dir);

signals:
	void hidden();
	void shown();
	
private:
	List *list;
	KAction *mOpen, *mDelete, *mSave, *mSaveAs, *mOpenpl, *mOpenNew;
	KToolBar *tb;

	KURL mPlaylistFile;
	bool modified;
};

#endif
