/*
  stores information after we found a header.
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __MPEGHEADERINFO_H
#define __MPEGHEADERINFO_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

 

#include <stdio.h>
#include <iostream.h>

#define _FREQUENCY_44100 0
#define _FREQUENCY_48000 1
#define _FREQUENCY_32000 2

#define _MODE_FULLSTEREO 0
#define _MODE_JOINT      1
#define _MODE_DUAL       2
#define _MODE_SINGLE     3

#define _VERSION_1       0
#define _VERSION_2       1


#define MAXSUBBAND         32
#define SCALEBLOCK         12



class MpegAudioHeader {

  int protection;
  int layer;
  int version;
  int padding;
  int frequency;
  int frequencyHz;
  int bitrateindex;
  int extendedmode;
  int mode;
  int inputstereo;
  int channelbitrate;
  int tableindex;
  int subbandnumber;
  int stereobound;
  int framesize;
  int layer3slots;
  unsigned char header[4];
  
 public:
  MpegAudioHeader();
  ~MpegAudioHeader();

  int parseHeader(unsigned char* buf);
  
  inline int getProtection()     { return protection; }
  inline int getLayer()          { return layer; }
  inline int getVersion()        { return version; }
  inline int getPadding()        { return padding; }
  inline int getFrequency()      { return frequency; }
  inline int getFrequencyHz()    { return frequencyHz; }
  inline int getBitrateindex()   { return bitrateindex; }
  inline int getExtendedmode()   { return extendedmode; }
  inline int getMode()           { return mode; }
  inline int getInputstereo()    { return inputstereo; }
  inline int getChannelbitrate() { return channelbitrate; }
  inline int getTableindex()     { return tableindex; }
  inline int getSubbandnumber()  { return subbandnumber; }
  inline int getStereobound()    { return stereobound; }
  inline int getFramesize()      { return framesize; }
  inline int getLayer3slots()    { return layer3slots; }

  int  getpcmperframe();


  void copyTo(MpegAudioHeader* dest);

  void print(char* name);
};
#endif
