/*
  bitwindow class
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __MPEGBITWINDOW_H
#define __MPEGBITWINDOW_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#ifndef WORDS_BIGENDIAN
#define _KEY 0
#else
#define _KEY 3
#endif



#define WINDOWSIZE    4096
#define BITWINDOWSIZE    (WINDOWSIZE*8)


class MpegAudioBitWindow {

  int  point,bitindex;
  char buffer[2*WINDOWSIZE];

 public:
  MpegAudioBitWindow(){bitindex=point=0;}

  void initialize(void)  {bitindex=point=0;}
  int  gettotalbit(void) const {return bitindex;}

  void putbyte(int c)    {buffer[point&(WINDOWSIZE-1)]=c;point++;}
  void wrap(void);
  void rewind(int bits)  {bitindex-=bits;}
  void forward(int bits) {bitindex+=bits;}
  int  getbits(int bits);

  int getbit(void) {
    register int r=(buffer[(bitindex>>3)&(WINDOWSIZE-1)]>>(7-(bitindex&7)))&1;
    //register int r=(buffer[bitindex>>3]>>(7-(bitindex&7)))&1;
    bitindex++;
    return r;
  }

  int getbits9(int bits) {
    register unsigned short a;
    {
      int offset=(bitindex>>3)&(WINDOWSIZE-1);
      //int offset=bitindex>>3;
      a=(((unsigned char)buffer[offset])<<8) | ((unsigned char)buffer[offset+1]);
    }

    a<<=(bitindex&7);
    bitindex+=bits;
    return (int)((unsigned int)(a>>(16-bits)));
  }

  int  peek8() {
    int offset = (bitindex>>3)&(WINDOWSIZE-1), a;
	a=(((unsigned char)buffer[offset])<<8) | ((unsigned char)buffer[offset+1]);
    return (a >> (8-(bitindex&7))) & 0xff;
  }  
  

};
#endif
