    /*

    Copyright (C) 2000 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Permission is also granted to link this program with the Qt
    library, treating Qt like a library that normally accompanies the
    operating system kernel, whether or not that is in fact the case.

    */

#include "freeverbui.h"
#include "connect.h"

using namespace Arts;

FreeVerbUI::FreeVerbUI(Synth_FREEVERB freeverb) : freeverb(freeverb)
{
	panel.width(330); panel.height(80); panel.show();

	roomsize.x(20); roomsize.y(10); roomsize.text("roomsize");
	roomsize.color("red"); roomsize.min(0); roomsize.max(1);
	roomsize.value(freeverb.roomsize());
	roomsize.parent(panel);
	roomsize.show();
	connect(roomsize,"value_changed", freeverb, "roomsize");

	damp.x(80); damp.y(10); damp.text("damp");
	damp.color("red"); damp.min(0); damp.max(1);
	damp.value(freeverb.damp());
	damp.parent(panel);
	damp.show();
	connect(damp,"value_changed", freeverb, "damp");

	wet.x(140); wet.y(10); wet.text("wet");
	wet.color("red"); wet.min(0); wet.max(1);
	wet.value(freeverb.wet());
	wet.parent(panel);
	wet.show();
	connect(wet,"value_changed", freeverb, "wet");

	dry.x(200); dry.y(10); dry.text("dry");
	dry.color("red"); dry.min(0); dry.max(1);
	dry.value(freeverb.dry());
	dry.parent(panel);
	dry.show();
	connect(dry,"value_changed", freeverb, "dry");

	width.x(260); width.y(10); width.text("width");
	width.color("red"); width.min(0); width.max(1);
	width.value(freeverb.width());
	width.parent(panel);
	width.show();
	connect(width,"value_changed", freeverb, "width");
}

FreeVerbUI::~FreeVerbUI()
{
}
