	/*

    Copyright (C) 2000 Jeff Tranter
                  tranter@pobox.com

              (C) 1998 Stefan Westerfeld
                  stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include <stdio.h>
#include "artsmodules.h"
#include "stdsynthmodule.h"

using namespace Arts;

class Synth_MIDI_DEBUG_impl : virtual public Synth_MIDI_DEBUG_skel,
							virtual public StdSynthModule
{
public:

	void streamInit()
	{
		printf("MIDI_DEBUG: streamInit\n");
	}
 
	void calculateBlock(unsigned long samples)
	{
		//printf("MIDI_DEBUG: calculateBlock(%ld)\n", samples);
	}

	void noteOnAt(const TimeStamp &time, mcopbyte channel, mcopbyte note, mcopbyte volume)
	{
		printf("MIDI_DEBUG: note on  channel %d, note %d, volume %d at %ld.%ld\n",
			   channel, note, volume, time.sec, time.usec);
	}

	void noteOffAt(const TimeStamp &time, mcopbyte channel, mcopbyte note)
	{
		printf("MIDI_DEBUG: note off channel %d, note %d at %ld.%ld\n",
			   channel, note, time.sec, time.usec);
	}

	void noteOn(mcopbyte channel, mcopbyte note, mcopbyte volume)
	{
		printf("MIDI_DEBUG: note on  channel %d, note %d, volume %d\n", channel, note, volume);
	}

	void noteOff(mcopbyte channel, mcopbyte note)
	{
		printf("MIDI_DEBUG: note off channel %d, note %d\n", channel, note);
	}

	TimeStamp time()
	{
		timeval tv;
		gettimeofday(&tv, 0);
		return TimeStamp(tv.tv_sec, tv.tv_usec);
	}

};

REGISTER_IMPLEMENTATION(Synth_MIDI_DEBUG_impl);
