#include "toplevel.h"

#include <qpixmap.h>
#include <qpainter.h>
#include <qdatetime.h>
#include <time.h>

#include <kapp.h>
#include <kglobal.h>
#include <klocale.h>


TopLevel::TopLevel ()
  : KMainWindow(0)
{
  world = new World(this);

  setupStatusBar();

  setCentralWidget(world);

  startTimer(1000); 
  timerEvent(NULL);

  setFixedSize(minimumSize());

  show();
}


TopLevel::~TopLevel ()
{
}


void TopLevel::setupStatusBar()
{
  statusBar()->insertItem("", ID_LOCALTIME, 1);
}  


void TopLevel::timerEvent(QTimerEvent *)
{
  time_t t = time(NULL) + World::offset;

  QDateTime dattim, dattim1;
  dattim.setTime_t(t);
  QString buffer = i18n("Local Time: %1, %2")
           .arg(KGlobal::locale()->formatDate(dattim.date(), true))
           .arg(KGlobal::locale()->formatTime(dattim.time(), true));

  struct tm *tmp = gmtime(&t);
  dattim1.setTime_t(mktime(tmp));
  QString buffer1 = i18n("GMT Time: %1, %2")
           .arg(KGlobal::locale()->formatDate(dattim1.date(), true))
           .arg(KGlobal::locale()->formatTime(dattim1.time(), true));

  statusBar()->changeItem(buffer + " " + buffer1, ID_LOCALTIME);

  world->setTime();
}
