/***************************u*******************************************
CatalogManager.h
Ktranslator Version 0.5.0 , catalog manager (headers )   

    KDE Translation Utility
    
    
    
    
    "Dedicated to the KDE Translators"
    
    
    
    
    
    
    program by Andrea Rizzi <rizzi@kde.org>  
    25 Feb 98 / 27 Apr 99

*********************************************************************/

#ifndef CATMNGR_H
#define CATMNGR_H

#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>


class CatalogManager: public QListView
{
Q_OBJECT
 public:
   CatalogManager(QWidget *parent, QString basePath, QString language);
    
   QString activeName();           // Return the name of app.
   QString activeMsgPath();
   QString activeTemPath();
   void buildDatabase();  
   void setLang( QString language) { lang=language.copy();}
   void setPath( QString fullpath) { path=fullpath.copy(); warning(path);}
 private:

   QString lang;
   QString path;
 public slots:
   void refresh();
   void install();
   void runapp();     
   void msgCheck();     

    signals:
   void setStatus(int);     
   void resetPb();
   void setProgress(int);    
   void setTotal(int);
   void openFilePot();
   void openFile();
   //void check();
   //void install();
   //void runApp();
   void updatePo();       
 protected:
  virtual void mousePressEvent( QMouseEvent *e);
};

class Catalog: public QListViewItem
{
public:
    Catalog( QListViewItem *parent,QString temPath,QString mesPath, const char * name = 0);
    void popUpMenu(QPoint pos,QWidget *receiver);
    QString name();
    QString msgPath();
    QString temPath();    
    
private:
     QFile fPo;
    QFile fPot;
    QString myName;
    Catalog *p;
    bool readable;
};




#endif






