/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */

#include <kdebug.h>
#include <knotifyclient.h>
#include <qpopupmenu.h>

#include "catalogsettings.h"
#include "editcmd.h"
#include "tagextractor.h"
#include "kbabelview.h"
#include "kbabeldictbox.h"
#include "mymultilineedit.h"
#include "roughtransdlg.h"

#include "resources.h"

QList<ModuleInfo> KBabelView::dictionaries()
{
   QList<ModuleInfo> list = dictBox->moduleInfos();

   return list;
}

void KBabelView::configureDictionary(const QString id)
{
   dictBox->configure(id);
}

void KBabelView::editDictionary(const QString id)
{
   dictBox->edit(id);
}


void KBabelView::aboutDictionary(const QString id)
{
   dictBox->aboutModule(id);
}

void KBabelView::informDictionary()
{
    dictBox->setTextChanged(_catalog->msgid(_currentIndex),
            _catalog->msgstr(_currentIndex),_catalog->comment(_currentIndex));
}

void KBabelView::setNewLanguage()
{
    IdentitySettings s = _catalog->identitySettings();

    dictBox->setLanguage(s.languageCode, s.languageName);
}


void KBabelView::wheelEvent(QWheelEvent *e)
{
    if( (e->state() & ControlButton) && (e->state() & AltButton))
    {
        if(e->delta() > 0)
        {
            gotoPrevFuzzyOrUntrans();
        }
        else
        {
            gotoNextFuzzyOrUntrans();
        }
    }
    else if(e->state() & ControlButton)
    {
        if(e->delta() > 0)
        {
            gotoPrevFuzzy();
        }
        else
        {
            gotoNextFuzzy();
        }
    }
    else if(e->state() & AltButton)
    {
        if(e->delta() > 0)
        {
            gotoPrevUntranslated();
        }
        else
        {
            gotoNextUntranslated();
        }
    }
    else
    {
        if(e->delta() > 0)
        {
            gotoPrev();
        }
        else
        {
            gotoNext();
        }
    }
   
    e->accept();
}



void KBabelView::roughTranslation()
{
    RoughTransDlg *dlg = new RoughTransDlg(dictBox, _catalog, this
            , "roughtransDlg");

    dlg->exec();

    delete dlg;
}


void KBabelView::updateTags()
{
    bool hadTags = _tags.count() > 0;

    _tags = _catalog->tagList(_currentIndex);

    if(_tagsMenu)
    {
        _tagsMenu->clear();
     
        QStringList tList;
        QStringList::Iterator it;
        int counter=0;
        for(it=_tags.begin(); it!=_tags.end(); ++it)
        {
            if(!tList.contains(*it))
            {
                _tagsMenu->insertItem(*it,counter);
                tList.append(*it);
            }
            counter++;
        }
    }

    bool haveTags = (_tags.count() > 0);
    
    if(isReadOnly())
        haveTags=false;

    if(haveTags != hadTags)
    {
        emit signalNextTagAvailable(haveTags);
        emit signalTagsAvailable(haveTags);
    }
}

void KBabelView::setTagsMenu(QPopupMenu *menu)
{
    _tagsMenu=menu;
    
    connect(_tagsMenu,SIGNAL(activated(int)),this,SLOT(insertTag(int)));
}


void KBabelView::insertTag(int n)
{
    EditCommand* tmp = new BeginCommand();
    tmp->setPart(EditCommand::Msgstr);
    tmp->setIndex(_currentIndex);
    _catalog->applyEditCommand(tmp,this);


    int line,col;
    msgstrEdit->getCursorPosition(&line,&col);
	int offset = msgstrEdit->pos2Offset(line,col);
    InsTextCmd* insCmd = new InsTextCmd(offset,_tagsMenu->text(n));
    insCmd->setPart(EditCommand::Msgstr);
    insCmd->setIndex(_currentIndex);
   
    msgstrEdit->processCommand(insCmd,false);
    forwardMsgstrEditCmd(insCmd);

    tmp = new EndCommand();
    tmp->setPart(EditCommand::Msgstr);
    tmp->setIndex(_currentIndex);
    _catalog->applyEditCommand(tmp,this);
}

void KBabelView::insertNextTag()
{
    int line,col;
    msgstrEdit->getCursorPosition(&line,&col);
	int offset = msgstrEdit->pos2Offset(line,col);

    QString s = _catalog->msgstr(_currentIndex).left(offset);
    
    TagExtractor te(s);
    uint num=te.countTags();
    if(num >= _tags.count())
    {
    	KNotifyClient::beep();
        return;
    }
     
    QString t=_tags[num];

    EditCommand* tmp = new BeginCommand();
    tmp->setPart(EditCommand::Msgstr);
    tmp->setIndex(_currentIndex);
    _catalog->applyEditCommand(tmp,this);

    InsTextCmd* insCmd = new InsTextCmd(offset,t);
    insCmd->setPart(EditCommand::Msgstr);
    insCmd->setIndex(_currentIndex);
   
    msgstrEdit->processCommand(insCmd,false);
    forwardMsgstrEditCmd(insCmd);
   
    tmp = new EndCommand();
    tmp->setPart(EditCommand::Msgstr);
    tmp->setIndex(_currentIndex);
    _catalog->applyEditCommand(tmp,this);
}

void KBabelView::showTagsMenu()
{
    if(_tagsMenu && _tags.count() > 0)
    {
        int y=msgstrEdit->height()/2;
        int x=msgstrEdit->width()/2;
        _tagsMenu->exec(msgstrEdit->mapToGlobal( QPoint(x,y) ) );

        return;
    }
}


