/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qlabel.h>
#include <qlayout.h>

#include <klocale.h>

#include "stateinfobox.h"


StateInfoBox::StateInfoBox(Device *device, QWidget *parent, const char *name) : QGroupBox(parent, name)
{
  QString  statestr;
  
  setTitle(i18n("Device state"));
  setFrameStyle(QFrame::Box | QFrame::Sunken);
  setLineWidth(1);
  
  switch (device->deviceState())
  {
    case Device::DeviceStateReady : statestr = i18n("This device is operational.");
    				    break;
    case Device::DeviceStateEmpty : statestr = i18n("This socket is empty.");
    				    break;
    default                       : statestr = i18n("No status information available.");
  }

  QLabel       *statevalue  = new QLabel(statestr, this, "statevalue");
           
  QHBoxLayout  *toplayout   = new QHBoxLayout(this, 16, 4,  "toplayout");    
  QVBoxLayout  *statelayout = new QVBoxLayout(toplayout, 4, "statelayout");
  
  statelayout->addSpacing(8);
  statelayout->addWidget(statevalue);
  statelayout->addStretch(1);
  
  toplayout->addStretch(1);
  
  toplayout->activate();
}


