/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include "idedrive.h"


IDEDrive::IDEDrive(const QString& modelname, idedrvclass iclass, 
		   DriveInfo *driveinfo) : _modelname(modelname),
				           _class(iclass),
                                           _driveinfo(driveinfo)
{
  int  pos = _modelname.find(' ');
  
  if (pos >= 0) _vendorname = _modelname.left(pos);
  else          _vendorname = i18n("Unknown vendor");

  lookupData();
}


/*
 * Public methods
 *****************/
 
QString  IDEDrive::deviceClassName()
{ 
  switch (_class)
  {
    case IDEClassDisk   : return QString(i18n("Harddisk drive"));
    case IDEClassFloppy : return QString(i18n("Floppy drive"));
    case IDEClassCDROM  : return QString(i18n("CD-ROM drive"));
    default             : return QString(i18n("Unknown device"));
  }
}


Device::devstate  IDEDrive::deviceState()
{
  return DeviceStateReady;
}


/*
 * Private methods
 ******************/
 
void  IDEDrive::lookupData()
{
  switch (_class)
  {
    case IDEClassDisk   :					// Fall through
    case IDEClassFloppy : _baseclass = BaseClassMassStorage;
                          break;
    case IDEClassCDROM  : _baseclass = BaseClassCDROM;
                          break;
    default             : _baseclass = BaseClassNone;
  }
}
