#include "common.h"

void modify_invisible_list( GtkWidget *widget, gpointer data );

void invisible_list_dialog( void )
{
	GtkWidget *dlg;
	
	dlg = create_invisible_list_window();

	gtk_widget_show_all( dlg );
}

GtkWidget* create_invisible_list_window ( void )
{
	GtkWidget *contact_list_window;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkWidget *label2;
	GtkWidget *scrolledwindow1;
	GtkWidget *clist1;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *hbuttonbox3;
	GtkWidget *button11;
	GtkWidget *button12;
	GtkWidget *hbuttonbox1;
	GtkWidget *button3;
	GtkWidget *button7;

	char *buf[2];
	char *luin, *lnick;

	GSList *contact;

	contact_list_window = gnome_dialog_new (NULL, NULL);
	gtk_object_set_data (GTK_OBJECT (contact_list_window), "contact_list_window", contact_list_window);
	gtk_window_set_default_size ( GTK_WINDOW( contact_list_window ), -2, 374);
	gtk_window_set_policy (GTK_WINDOW (contact_list_window), TRUE, TRUE, FALSE);

	gtk_window_set_title( GTK_WINDOW( contact_list_window ), _("GnomeICU: Invisible List") );
	gtk_window_set_wmclass( GTK_WINDOW( contact_list_window ), "Invisible_List", "GnomeICU" );

	dialog_vbox1 = GNOME_DIALOG (contact_list_window)->vbox;
	gtk_object_set_data (GTK_OBJECT (contact_list_window), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "vbox2", vbox2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), vbox2, TRUE, TRUE, 0);

	label2 = gtk_label_new (_("Drag the users you wish to add to your\ninvisible list into this window, and then click\nthe \"Apply\" button below."));
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "label2", label2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox2), label2, FALSE, FALSE, 0);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "scrolledwindow1", scrolledwindow1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (vbox2), scrolledwindow1, TRUE, TRUE, 0);

	clist1 = gtk_clist_new (2);
	gtk_widget_ref (clist1);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "clist1", clist1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (clist1);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist1);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 65);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
	gtk_clist_column_titles_show (GTK_CLIST (clist1));

	contact = Contacts;

	while( contact != NULL )
	{
		if( kontakt->invis_list == TRUE )
		{
			luin = g_strdup_printf( "%d", kontakt->uin );
			lnick = kontakt->nick;
			buf[0] = luin;
			buf[1] = lnick;
			gtk_clist_append( GTK_CLIST( clist1 ), buf );
			g_free( luin );
		}
		contact = contact->next;
	}

	gtk_drag_dest_set( clist1, GTK_DEST_DEFAULT_ALL, target_table, 1,
	                   GDK_ACTION_COPY | GDK_ACTION_MOVE );
	gtk_signal_connect( GTK_OBJECT( clist1 ), "drag_data_received",
	                    GTK_SIGNAL_FUNC( label_drag_data_received ), clist1 );

	label3 = gtk_label_new (_("UIN"));
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "label3", label3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label3);

	label4 = gtk_label_new (_("Nickname"));
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "label4", label4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label4);

	hbuttonbox3 = gtk_hbutton_box_new ();
	gtk_widget_ref (hbuttonbox3);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "hbuttonbox3", hbuttonbox3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbuttonbox3);
	gtk_box_pack_start (GTK_BOX (vbox2), hbuttonbox3, FALSE, FALSE, 0);

	button12 = gtk_button_new_with_label (_("User's Info"));
	gtk_widget_ref (button12);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "button12", button12,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_object_set_data( GTK_OBJECT( button12 ), "clist", clist1 );
	gtk_signal_connect( GTK_OBJECT( button12 ), "clicked",
	                    GTK_SIGNAL_FUNC( info_list_candidate ),
	                    NULL );

	gtk_widget_show (button12);
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), button12);
	GTK_WIDGET_SET_FLAGS (button12, GTK_CAN_DEFAULT);

	button11 = gtk_button_new_with_label (_("Remove User"));
	gtk_widget_ref (button11);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "button11", button11,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_object_set_data( GTK_OBJECT( button11 ), "clist", clist1 );
	gtk_signal_connect( GTK_OBJECT( button11 ), "clicked",
	                    GTK_SIGNAL_FUNC( remove_contact_list_candidate ),
	                    NULL );

	gtk_widget_show (button11);
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), button11);
	GTK_WIDGET_SET_FLAGS (button11, GTK_CAN_DEFAULT);

	hbuttonbox1 = GNOME_DIALOG (contact_list_window)->action_area;
	gtk_object_set_data (GTK_OBJECT (contact_list_window), "hbuttonbox1", hbuttonbox1);
	gtk_widget_show (hbuttonbox1);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox1), 8);

	gnome_dialog_append_button (GNOME_DIALOG (contact_list_window),
	                            GNOME_STOCK_BUTTON_APPLY );
	button3 = g_list_last (GNOME_DIALOG (contact_list_window)->buttons)->data;
	gtk_widget_ref (button3);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "button3", button3,
	                          (GtkDestroyNotify) gtk_widget_unref);

	gtk_signal_connect( GTK_OBJECT( button3 ), "clicked",
	                    GTK_SIGNAL_FUNC( modify_invisible_list ),
	                    clist1 );

	gtk_widget_set_sensitive( button3, FALSE );

	gtk_widget_show (button3);
	GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

	gtk_object_set_data( GTK_OBJECT( button11 ), "apply", button3 );
	gtk_object_set_data( GTK_OBJECT( clist1 ), "apply", button3 );

	gnome_dialog_append_button (GNOME_DIALOG (contact_list_window), GNOME_STOCK_BUTTON_CLOSE);
	button7 = g_list_last (GNOME_DIALOG (contact_list_window)->buttons)->data;
	gtk_widget_ref (button7);
	gtk_object_set_data_full (GTK_OBJECT (contact_list_window), "button7", button7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect_object( GTK_OBJECT( button7 ), "clicked",
	                           (GtkSignalFunc) gtk_widget_destroy,
	                           GTK_OBJECT( contact_list_window ) );
	gtk_widget_show (button7);
	GTK_WIDGET_SET_FLAGS (button7, GTK_CAN_DEFAULT);

	return contact_list_window;
}

void modify_invisible_list( GtkWidget *widget, gpointer data )
{
	GtkCList *clist = GTK_CLIST( data );
	gchar *nick;
	int cx;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "modify_invisible_list\n" );
#endif

	contact = Contacts;
	
	while( contact != NULL )
	{
		kontakt->invis_list = FALSE;
		contact = contact->next;
	}

	for( cx = 0; cx < clist->rows; cx ++ )
	{
		gtk_clist_get_text( clist, cx, 0, &nick );
		contact = Contacts;
		while( contact != NULL )
		{
			if( atoi( nick ) == kontakt->uin )
			{
				kontakt->invis_list = TRUE;
				kontakt->vis_list = FALSE;
			}

			contact = contact->next;
		}
	}

	snd_vis_list();
	snd_invis_list();

	gtk_widget_set_sensitive( widget, FALSE );
}
