/********************************
 Create a new chat dialog window
 (c) 1999 Jeremy Wise
 GnomeICU
*********************************/

/*** GnomeICU header files ***/
#include "common.h"

#ifdef GNOME_ICON
#include <libgnomeui/gnome-window-icon.h>
#endif

typedef struct
{
	gpointer data;
	ChatSession *cs;
} dataandcs;

/*** Local function declarations ***/
static void SetForeground( GtkWidget *widget, dataandcs *data );
static void SetBackground( GtkWidget *widget, dataandcs *data );
static void CreateSetFGWindow( GtkWidget *widget, ChatSession *csession );
static void CreateSetBGWindow( GtkWidget *widget, ChatSession *csession );

static void chat_focus_in( GtkWindow *window, GtkWidget *widget, ChatSession *csession );
static void chat_focus_out( GtkWindow *window, GtkWidget *widget, ChatSession *csession );
static void chat_focus_changed( ChatSession *csession, gboolean have_focus );
static void changedShouldSendFocus (GtkWidget *widget, ChatSession *csession);
static gboolean shouldSendFocus (ChatSession *csession);
static void sendFocus (ChatSession *csession);


/*** Global functions ***/
void ChatWindowNew(ChatSession *csession)
{
     
     GtkWidget *vbox1;
     GtkWidget *chat_toolbar;
     GtkWidget *tmp_toolbar_icon;
     GtkWidget *B_save_chat;
     GtkWidget *B_set_fg;
     GtkWidget *B_set_bg;
     GtkWidget *B_toggle_sound;
     GtkWidget *B_close_chat;
     GtkWidget *vpaned;
     GtkWidget *hpaned;
     GtkWidget *frame2;
     GtkWidget *scrolledwindow2;
     GtkWidget *scrolledwindow3;
     GtkWidget *notebook;
     GtkWidget *label;
     GtkWidget *listitem;
     GList *listforgtklist = NULL;


     GtkTooltips *tooltip;
     GtkStyle *style;
     gchar *wintitle_or_path;



#ifdef TRACE_FUNCTION
     g_print( "ChatWindowNew\n" );
#endif


     csession->chatwindow = gtk_window_new( GTK_WINDOW_TOPLEVEL );
     wintitle_or_path = g_strdup_printf( _("GnomeICU: %s"), ( strlen( our_info->nick ) ? our_info->nick : _("User")));
     gtk_window_set_title( GTK_WINDOW( csession->chatwindow ), wintitle_or_path );
     g_free( wintitle_or_path );


#ifdef GNOME_ICON
     wintitle_or_path = make_file_path( "gnomeicu-chat.png" );
     gnome_window_icon_set_from_file( GTK_WINDOW(csession->chatwindow), wintitle_or_path );
     g_free( wintitle_or_path );
#endif

     gtk_container_border_width( GTK_CONTAINER( csession->chatwindow ), 0 );
     gtk_window_set_default_size( GTK_WINDOW( csession->chatwindow ), 450, 400 );
     gtk_widget_realize( csession->chatwindow );

     gtk_window_set_policy( GTK_WINDOW( csession->chatwindow ), TRUE, TRUE, FALSE );

     vbox1 = gtk_vbox_new (FALSE, 0);
     gtk_widget_ref (vbox1);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "vbox1", vbox1,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (vbox1);
     gtk_container_add (GTK_CONTAINER (csession->chatwindow), vbox1);

     chat_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
     gtk_widget_ref (chat_toolbar);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "chat_toolbar", chat_toolbar,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (chat_toolbar);
     gtk_box_pack_start (GTK_BOX (vbox1), chat_toolbar, FALSE, TRUE, 0);
     gtk_container_set_border_width (GTK_CONTAINER (chat_toolbar), 5);
     gtk_toolbar_set_space_size (GTK_TOOLBAR (chat_toolbar), 20);
     gtk_toolbar_set_space_style (GTK_TOOLBAR (chat_toolbar), GTK_TOOLBAR_SPACE_LINE);
     gtk_toolbar_set_button_relief (GTK_TOOLBAR (chat_toolbar), GTK_RELIEF_NONE);

     tmp_toolbar_icon = gnome_stock_pixmap_widget (csession->chatwindow, GNOME_STOCK_PIXMAP_SAVE_AS);
     B_save_chat = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
					       GTK_TOOLBAR_CHILD_BUTTON,
					       NULL,
					       _("Save"),
					       NULL, NULL,
					       tmp_toolbar_icon, NULL, NULL);
     gtk_widget_ref (B_save_chat);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "B_save_chat", B_save_chat,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (B_save_chat);

     tooltip = gtk_tooltips_new();
     gtk_tooltips_set_tip( tooltip, B_save_chat, _("Save Chat"), NULL );

     tmp_toolbar_icon = gnome_stock_pixmap_widget (csession->chatwindow, GNOME_STOCK_PIXMAP_COLORSELECTOR);
     B_set_fg = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
					    GTK_TOOLBAR_CHILD_BUTTON,
					    NULL,
					    _("Foreground"),
					    NULL, NULL,
					    tmp_toolbar_icon, NULL, NULL);
     gtk_widget_ref (B_set_fg);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "B_set_fg", B_set_fg,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (B_set_fg);

     tooltip = gtk_tooltips_new();
     gtk_tooltips_set_tip( tooltip, B_set_fg, _("Set Foreground Color"), NULL );

     tmp_toolbar_icon = gnome_stock_pixmap_widget (csession->chatwindow, GNOME_STOCK_PIXMAP_COLORSELECTOR);
     B_set_bg = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
					    GTK_TOOLBAR_CHILD_BUTTON,
					    NULL,
					    _("Background"),
					    NULL, NULL,
					    tmp_toolbar_icon, NULL, NULL);
     gtk_widget_ref (B_set_bg);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "B_set_bg", B_set_bg,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (B_set_bg);

     tooltip = gtk_tooltips_new();
     gtk_tooltips_set_tip( tooltip, B_set_bg, _("Set Background Color"), NULL );

     tmp_toolbar_icon = gnome_stock_pixmap_widget (csession->chatwindow, GNOME_STOCK_PIXMAP_VOLUME);
     B_toggle_sound = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
						  GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
						  NULL,
						  _("Sound"),
						  NULL, NULL,
						  tmp_toolbar_icon, NULL, NULL);
     gtk_widget_ref (B_toggle_sound);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "B_toggle_sound", B_toggle_sound,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (B_toggle_sound);

     tooltip = gtk_tooltips_new();
     gtk_tooltips_set_tip( tooltip, B_toggle_sound, _("Enable/Disable Sound"), NULL );

     tmp_toolbar_icon = gnome_stock_pixmap_widget (csession->chatwindow, GNOME_STOCK_PIXMAP_REDO);
     csession->should_send_focus = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
						  GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
						  NULL,
						  _("Send Focus"),
						  NULL, NULL,
						  tmp_toolbar_icon, NULL, NULL);
     gtk_widget_ref (csession->should_send_focus);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), 
			       "B_toggle_focus", csession->should_send_focus,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (csession->should_send_focus);
     
     gtk_signal_connect (GTK_OBJECT (csession->should_send_focus), "toggled",
			 GTK_SIGNAL_FUNC (changedShouldSendFocus),
			 csession);

     tooltip = gtk_tooltips_new();
     gtk_tooltips_set_tip( tooltip, csession->should_send_focus, _("Send \"User is Away\" Messages"), NULL );

     tmp_toolbar_icon = gnome_stock_pixmap_widget (csession->chatwindow, GNOME_STOCK_PIXMAP_CLOSE);
     B_close_chat = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
						GTK_TOOLBAR_CHILD_BUTTON,
						NULL,
						_("Close"),
						NULL, NULL,
						tmp_toolbar_icon, NULL, NULL);
     gtk_widget_ref (B_close_chat);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "B_close_chat", B_close_chat,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (B_close_chat);

     tooltip = gtk_tooltips_new();
     gtk_tooltips_set_tip( tooltip, B_close_chat, _("Close Chat"), NULL );

     vpaned = gtk_vpaned_new ();
     gtk_widget_show (vpaned);
     gtk_box_pack_start (GTK_BOX (vbox1), vpaned, TRUE, TRUE, 0);


     notebook = gtk_notebook_new();
     gtk_paned_pack1 (GTK_PANED (vpaned), notebook, TRUE, TRUE);
     gtk_widget_show(notebook);

     csession->vbox = gtk_vbox_new( TRUE, 3 );    
     label = gtk_label_new(_("Split"));
     

     gtk_notebook_append_page( GTK_NOTEBOOK (notebook), csession->vbox, label);
     gtk_widget_show(csession->vbox);

     hpaned = gtk_hpaned_new();
     label = gtk_label_new(_("IRC"));
     gtk_notebook_append_page( GTK_NOTEBOOK (notebook), hpaned, label);
     gtk_widget_show(hpaned);


     scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
     gtk_widget_show (scrolledwindow3);
     gtk_paned_pack1( GTK_PANED(hpaned), scrolledwindow3, TRUE, TRUE);
     gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow3), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

     csession->ircicuchat = icu_chat_new (NULL, NULL);
     gtk_container_add (GTK_CONTAINER (scrolledwindow3), csession->ircicuchat);
     gtk_widget_show(csession->ircicuchat);


     csession->list = gtk_list_new();
     gtk_paned_pack2( GTK_PANED(hpaned), csession->list, TRUE, TRUE);


// DO LATER     gtk_paned_set_position( GTK_PANED(hpaned), value);

     listitem = gtk_list_item_new_with_label(our_info->nick);
     listforgtklist = g_list_append(NULL, listitem);
     gtk_list_append_items(GTK_LIST(csession->list), listforgtklist); 
     gtk_widget_show(listitem);
     gtk_widget_show(csession->list);
     
     frame2 = gtk_frame_new ( strlen( our_info->nick ) ? our_info->nick : _("User") );
     gtk_widget_ref (frame2);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "frame2", frame2,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (frame2);
     gtk_paned_pack2 (GTK_PANED (vpaned), frame2, TRUE, TRUE);
     gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);
     scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
     gtk_widget_ref (scrolledwindow2);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "scrolledwindow2", scrolledwindow2,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (scrolledwindow2);
     gtk_container_add (GTK_CONTAINER (frame2), scrolledwindow2);
     gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

     csession->sendicuchat = icu_chat_new (NULL, NULL);
     gtk_widget_ref (csession->sendicuchat);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "csession->sendicuchat", csession->sendicuchat,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (csession->sendicuchat);
     gtk_container_add (GTK_CONTAINER (scrolledwindow2), csession->sendicuchat);
     icu_chat_set_editable ( ICU_CHAT (csession->sendicuchat), TRUE);
     icu_chat_set_word_wrap( ICU_CHAT( csession->sendicuchat ), TRUE );

     gtk_signal_connect (GTK_OBJECT (csession->chatwindow), "focus_in_event",
			 GTK_SIGNAL_FUNC (chat_focus_in),
			 csession);
     gtk_signal_connect (GTK_OBJECT (csession->chatwindow), "focus_out_event",
			 GTK_SIGNAL_FUNC (chat_focus_out),
			 csession);
     gtk_signal_connect (GTK_OBJECT (B_set_fg), "clicked",
			 GTK_SIGNAL_FUNC (CreateSetFGWindow),
			 csession);
     gtk_signal_connect (GTK_OBJECT (B_set_bg), "clicked",
			 GTK_SIGNAL_FUNC (CreateSetBGWindow), csession);
     gtk_signal_connect( GTK_OBJECT( B_save_chat ), "clicked",
			 GTK_SIGNAL_FUNC( chat_save ), csession);
     gtk_signal_connect (GTK_OBJECT (B_close_chat), "clicked",
			 GTK_SIGNAL_FUNC (TCPTerminateChatSession), csession);
     gtk_signal_connect_object (GTK_OBJECT (B_close_chat), "clicked",
				GTK_SIGNAL_FUNC (gtk_widget_destroy),
				GTK_OBJECT (csession->chatwindow));
     gtk_signal_connect (GTK_OBJECT (csession->sendicuchat), "key_press_event",
			 GTK_SIGNAL_FUNC (TCPChatSend),
			 csession);
     gtk_signal_connect (GTK_OBJECT (csession->sendicuchat),
			 "selection_received",
			 GTK_SIGNAL_FUNC (TCPChatSendSel), csession);

     style = gtk_style_new();
     style->font = gdk_font_load( ChatFontString );
     if( style->font == NULL )
	  style->font = gdk_font_load( _("-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1") );
     gtk_widget_set_style( csession->sendicuchat, style );
     gdk_font_unref( style->font );

     gtk_widget_show( csession->chatwindow );

}


void JoinChatSession(ChatSession *csession, ChatContact *ccontact)
{

     GtkWidget *frame1;
     GtkWidget *scrolledwindow1;
     GtkStyle *style;
     GList *listitem;
     
#ifdef TRACE_FUNCTION
     g_print( "JoinChatSession\n" );
#endif
     
     ccontact->chatsession = csession;
     
     csession->members = g_slist_append(csession->members, ccontact);
     
     ccontact->linein = g_string_new("\0");
     
     frame1 = gtk_frame_new ( ccontact->contact->nick );
     gtk_widget_ref (frame1);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "frame1", frame1,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (frame1);
     
     gtk_box_pack_start( GTK_BOX (csession->vbox), frame1, TRUE, TRUE, 0);
     
     
     gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);
     

     ccontact->irclistitem = gtk_list_item_new_with_label(ccontact->contact->nick);
     listitem = g_list_append(NULL, ccontact->irclistitem);
     gtk_list_append_items(GTK_LIST(csession->list), listitem); 
     gtk_widget_show(ccontact->irclistitem);
     
     scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
     gtk_widget_ref (scrolledwindow1);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "scrolledwindow1", scrolledwindow1,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (scrolledwindow1);
     gtk_container_add (GTK_CONTAINER (frame1), scrolledwindow1);
     gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
     ccontact->spliticuchat = icu_chat_new (NULL, NULL);
     gtk_widget_ref (ccontact->spliticuchat);
     gtk_object_set_data_full (GTK_OBJECT (csession->chatwindow), "ccontact->spliticuchat", ccontact->spliticuchat,
			       (GtkDestroyNotify) gtk_widget_unref);
     gtk_widget_show (ccontact->spliticuchat);
     gtk_container_add (GTK_CONTAINER (scrolledwindow1), ccontact->spliticuchat);
     icu_chat_set_word_wrap( ICU_CHAT( ccontact->spliticuchat ), TRUE );

     style = gtk_style_new();
     style->font = gdk_font_load( ChatFontString );
     if( style->font == NULL )
	  style->font = gdk_font_load( _("-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1") );
     gtk_widget_set_style( ccontact->spliticuchat, style );
     gdk_font_unref( style->font );



}

void PartChatSession(ChatContact *ccontact)
{

     GList *listforgtklistitem;

#ifdef TRACE_FUNCTION
    g_print("PartChatSession\n");
#endif

    if (ccontact->gdk_input)
	 gdk_input_remove(ccontact->gdk_input);

    if (ccontact->socket)
	 close(ccontact->socket);

    ccontact->chatsession->members = g_slist_remove(ccontact->chatsession->members, ccontact);
    
    if (ccontact->linein)
	 g_string_free(ccontact->linein, TRUE);

    if (ccontact->spliticuchat && GTK_IS_WIDGET(ccontact->spliticuchat) && gtk_widget_get_ancestor(ccontact->spliticuchat, GTK_TYPE_FRAME))
	gtk_widget_destroy ( gtk_widget_get_ancestor(ccontact->spliticuchat, GTK_TYPE_FRAME));

    if (GTK_IS_LIST_ITEM(ccontact->irclistitem) && GTK_IS_LIST(ccontact->chatsession->list))
    {
	 listforgtklistitem = g_list_append(NULL, ccontact->irclistitem);
	 gtk_list_remove_items(GTK_LIST(ccontact->chatsession->list),listforgtklistitem );
	 g_list_free(listforgtklistitem);
    }
        
    if (ccontact->font)
	 gdk_font_unref (ccontact->font);

    g_free(ccontact);

}


void AddCharacter(ChatContact *ccontact, gchar c)
{
     GdkColor *background = NULL;
     GdkColor *foreground = NULL;
     GtkStyle *style;
     
#ifdef TRACE_FUNCTION
     g_print( "AddCharacter\n" );
#endif
     
     foreground = (GdkColor *)g_malloc0( sizeof( GdkColor ) );
     background = (GdkColor *)g_malloc0( sizeof( GdkColor ) );
     
     foreground->red = 256 * ccontact->fg_red;
     foreground->green = 256 * ccontact->fg_green;
     foreground->blue = 256 * ccontact->fg_blue;
     foreground->pixel = (gulong)( ccontact->fg_red * 65536 +
				   ccontact->fg_green * 256 +
				   ccontact->fg_blue );
     
     background->red = 256 * ccontact->bg_red;
     background->green = 256 * ccontact->bg_green;
     background->blue = 256 * ccontact->bg_blue;
     background->pixel = (gulong)( ccontact->bg_red * 65536 +
				   ccontact->bg_green * 256 +
				   ccontact->bg_blue );
     
     gdk_color_alloc( gtk_widget_get_colormap( ccontact->spliticuchat ), foreground );
     gdk_color_alloc( gtk_widget_get_colormap( ccontact->spliticuchat ), background );

     style = gtk_style_new();
     memcpy( &style->fg[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ));
     memcpy( &style->text[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ));
     memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ));
     gtk_widget_set_style( ccontact->spliticuchat, style );
     
     g_string_append_c(ccontact->linein, c);
     
     icu_chat_insert( ICU_CHAT( ccontact->spliticuchat ), ChatFont, foreground, background, &c, 1 );
     
     g_free( foreground );
     g_free( background );
     
}

void AddNewline(ChatContact *ccontact)
{

     char *chat_history_line;

     GdkColor *background = NULL;
     GdkColor *foreground = NULL;

#ifdef TRACE_FUNCTION
     g_print( "AddNewline\n" );
#endif
     
     chat_history_line = g_strdup_printf("%s> %s\n", ccontact->contact->nick,
					  ccontact->linein->str);
     ccontact->chatsession->history = g_slist_append(ccontact->chatsession->history,
					chat_history_line);
     
     icu_chat_insert( ICU_CHAT( ccontact->chatsession->ircicuchat ), NULL, foreground, background, chat_history_line, -1 );
     g_string_truncate(ccontact->linein, 0);
     icu_chat_insert( ICU_CHAT( ccontact->spliticuchat ), NULL, foreground, background, "\n", 1 );
     
}

void InsertLine(ChatSession *csession)
{
     
     char *chat_history_line;
  
     GdkColor *background = NULL;
     GdkColor *foreground = NULL;
     
#ifdef TRACE_FUNCTION
     g_print( "InsertLine\n" );
#endif
     
     chat_history_line = g_strdup_printf("%s> %s\n", our_info->nick,
					 csession->lineout->str);
     
     csession->history = g_slist_append(csession->history,
					chat_history_line);
     icu_chat_insert( ICU_CHAT( csession->ircicuchat ),
		      NULL, foreground, background, chat_history_line , -1 );
     g_string_truncate(csession->lineout, 0);
     
}

void DelCharacter(ChatContact *ccontact)
{

#ifdef TRACE_FUNCTION
	g_print( "DelCharacter\n" );
#endif

	g_string_truncate(ccontact->linein, (ccontact->linein->len - 1 >= 0) ? (ccontact->linein->len - 1) : 0 );

	icu_chat_backward_delete( ICU_CHAT( ccontact->spliticuchat ), 1 );
}


/*** Local functions ***/
void SetForeground( GtkWidget *widget, dataandcs *data )
{
     static GtkStyle *style = NULL;
     GdkColor *foreground, *background;

     GtkColorSelection *colorsel;
     gdouble color[4];
     BYTE rgb[5];

     ChatSession *csession = data->cs;

#ifdef TRACE_FUNCTION
     g_print( "SetForeground\n" );
#endif

     
     colorsel = GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( data->data )->colorsel );
     gtk_color_selection_get_color( colorsel, color );

     rgb[0] = 0x00;
     chat_fg_red = rgb[1] = (BYTE)( 255.0F * color[0] );
     chat_fg_green = rgb[2] = (BYTE)( 255.0F * color[1] );
     chat_fg_blue = rgb[3] = (BYTE)( 255.0F * color[2] );
     rgb[4] = 0x00;

     foreground = g_new0( GdkColor, 1 );
     background = g_new0( GdkColor, 1 );

     foreground->red = 256 * chat_fg_red;
     foreground->green = 256 * chat_fg_green;
     foreground->blue = 256 * chat_fg_blue;
     foreground->pixel = (gulong)(
	  chat_fg_red * 65536 +
	  chat_fg_green * 256 +
	  chat_fg_blue );

     background->red = 256 * chat_bg_red;
     background->green = 256 * chat_bg_green;
     background->blue = 256 * chat_bg_blue;
     background->pixel = (gulong)(
	  chat_bg_red * 65536 +
	  chat_bg_green * 256 +
	  chat_bg_blue );

     gdk_color_alloc( gtk_widget_get_colormap( csession->sendicuchat ), foreground );
     gdk_color_alloc( gtk_widget_get_colormap( csession->sendicuchat ), background );

     if( style != NULL )
	  gtk_style_unref( style );

     style = gtk_style_new();
     style->font = gdk_font_load( ChatFontString );
     if( style->font == NULL )
	  style->font = gdk_font_load( _("-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1") );
     memcpy( &style->fg[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
     memcpy( &style->text[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
     memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );

     gtk_widget_set_style( csession->sendicuchat, style );
/*	gdk_font_unref( style->font );*/
	

     TCPChatWriteAll(csession, rgb, 5);

			 

}

void SetBackground( GtkWidget *widget, dataandcs *data )
{
     static GtkStyle *style = NULL;
     GdkColor *foreground, *background;

     GtkColorSelection *colorsel;
     gdouble color[4];
     BYTE rgb[5];

     ChatSession *csession = data->cs;

#ifdef TRACE_FUNCTION
     g_print( "SetBackground\n" );
#endif

     colorsel = GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( data->data )->colorsel );
     gtk_color_selection_get_color( colorsel, color );

     rgb[0] = 0x01;
     chat_bg_red = rgb[1] = (BYTE)( 255.0F * color[0] );
     chat_bg_green = rgb[2] = (BYTE)( 255.0F * color[1] );
     chat_bg_blue = rgb[3] = (BYTE)( 255.0F * color[2] );
     rgb[4] = 0x00;

     foreground = g_new0( GdkColor, 1 );
     background = g_new0( GdkColor, 1 );

     foreground->red = 256 * chat_fg_red;
     foreground->green = 256 * chat_fg_green;
     foreground->blue = 256 * chat_fg_blue;
     foreground->pixel = (gulong)(
	  chat_fg_red * 65536 +
	  chat_fg_green * 256 +
	  chat_fg_blue );

     background->red = 256 * chat_bg_red;
     background->green = 256 * chat_bg_green;
     background->blue = 256 * chat_bg_blue;
     background->pixel = (gulong)(
	  chat_bg_red * 65536 +
	  chat_bg_green * 256 +
	  chat_bg_blue );

     gdk_color_alloc( gtk_widget_get_colormap( csession->sendicuchat ), foreground );
     gdk_color_alloc( gtk_widget_get_colormap( csession->sendicuchat ), background );

     if( style != NULL )
	  gtk_style_unref( style );

     style = gtk_style_new();
     style->font = gdk_font_load( ChatFontString );
     if( style->font == NULL )
	  style->font = gdk_font_load( _("-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1") );
     memcpy( &style->fg[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
     memcpy( &style->text[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
     memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );

     gtk_widget_set_style( csession->sendicuchat, style );
/*	gdk_font_unref( style->font );*/

     TCPChatWriteAll(csession, rgb, 5);
}

void CreateSetFGWindow( GtkWidget *widget, ChatSession *csession )
{
     dataandcs *pass_data = g_new0( dataandcs, 1 );
     GtkWidget *window;
     gdouble color[4];
     static int first = FALSE;

     window = gtk_color_selection_dialog_new( _("Set Foreground Color") );

#ifdef TRACE_FUNCTION
     g_print( "CreateSetFGWindow\n" );
#endif

     if( first )
     {
	  color[0] = color[1] = color[2] = color[3] = 0;
	  first = FALSE;
     }
     else
     {
	  color[0] = 256 * chat_fg_red;
	  color[1] = 256 * chat_fg_green;
	  color[2] = 256 * chat_fg_blue;  
	  color[3] = (gulong)(
	       chat_fg_red * 65536 +
	       chat_fg_green * 256 +
	       chat_fg_blue );
     }

     pass_data->cs = csession;
     pass_data->data = window;

     gtk_color_selection_set_color(
	  GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	  color );

     gtk_color_selection_set_opacity(
	  GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	  TRUE );
	
     gtk_color_selection_set_update_policy(
	  GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	  GTK_UPDATE_CONTINUOUS );
	
     gtk_signal_connect(
	  GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	  "clicked", GTK_SIGNAL_FUNC( SetForeground ), pass_data );

     gtk_signal_connect_object(
	  GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	  "clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

     gtk_signal_connect_object(
	  GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->cancel_button ),
	  "clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

     gtk_widget_show( window );
}

void CreateSetBGWindow( GtkWidget *widget, ChatSession *csession )
{
     dataandcs *pass_data = g_new0( dataandcs, 1 );
     GtkWidget *window;
     gdouble color[4];

     static int first = TRUE;

     window = gtk_color_selection_dialog_new( _("Set Background Color") );


#ifdef TRACE_FUNCTION
     g_print( "CreateSetBGWindow\n" );
#endif

     pass_data->cs = csession;
     pass_data->data = window;

     if( first )
     {
	  color[0] = color[1] = color[2] = color[3] = 0;
	  first = FALSE;
     }
     else
     {
	  color[0] = 256 * chat_bg_red;
	  color[1] = 256 * chat_bg_green;
	  color[2] = 256 * chat_bg_blue;  
	  color[3] = (gulong)(
	       chat_bg_red * 65536 +
	       chat_bg_green * 256 +
	       chat_bg_blue );
     }

     gtk_color_selection_set_color(
	  GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	  color );

     gtk_color_selection_set_opacity(
	  GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	  TRUE );
	
     gtk_color_selection_set_update_policy(
	  GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	  GTK_UPDATE_CONTINUOUS );
	
     gtk_signal_connect(
	  GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	  "clicked", GTK_SIGNAL_FUNC( SetBackground ), pass_data );

     gtk_signal_connect_object(
	  GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	  "clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

     gtk_signal_connect_object(
	  GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->cancel_button ),
	  "clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

     gtk_widget_show( window );
}


void chat_focus_in( GtkWindow *window, GtkWidget *widget, ChatSession *csession )
{
     chat_focus_changed(csession, TRUE);
}

void chat_focus_out( GtkWindow *window, GtkWidget *widget, ChatSession *csession )
{
     chat_focus_changed(csession, FALSE);
}

static void chat_focus_changed( ChatSession *csession, gboolean have_focus ) {
     
     csession->have_chat_focus = have_focus;
     if (shouldSendFocus(csession)) {
	  sendFocus( csession );
     }
}

static void changedShouldSendFocus (GtkWidget *widget, ChatSession *csession)
{
     if (shouldSendFocus(csession)) {
	  sendFocus(csession);
     }
}

static void sendFocus (ChatSession *csession)
{
     char byte;
     if (csession->have_chat_focus) {
	  byte = 0x03;
     } else {
	  byte = 0x04;
     }
     TCPChatWriteAll( csession, &byte, 1 );
     csession->reported_chat_focus = csession->have_chat_focus;
}

static gboolean shouldSendFocus (ChatSession *csession) 
{
     return (csession->have_chat_focus != csession->reported_chat_focus &&
	     GTK_TOGGLE_BUTTON (csession->should_send_focus)->active);
}


