/***************************************
 Functions to operate the panel applet
 (c) 1999 Jeremy Wise
 GnomeICU
****************************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <string.h>
#include <gdk_imlib.h>
#include <applet-widget.h>

GtkWidget *frame;
GtkWidget *frame_outline;
/*GtkWidget *frame_outline2;*/
GtkWidget *mess_label;
GtkWidget *mess_pm;
GtkWidget *applet;

gboolean have_read_config = FALSE;

static void update_orient (PanelOrientType orient, int size);

/*** Local function declarations ***/
static gint applet_save_state_cb( GtkWidget *w, const char *privcfgpath, const char *globcfgpath, gpointer data );
static void applet_exposed_cb( GtkWidget *widget, gpointer data );
static GtkWidget *create_applet( void );
static void init_applet_signals( GtkWidget *window );
static void applet_change_orient( GtkWidget *w, PanelOrientType o, gpointer data );
void place_widgets (void);

#ifdef HAVE_PANEL_PIXEL_SIZE
static void applet_change_size( GtkWidget *w, int size, gpointer data );
#endif

/*** Global functions ***/
void make_applet( int argc, char *argv[], struct poptOption arguments[] )
{
	GtkStyle *style;
	GtkWidget *widget;

#ifdef TRACE_FUNCTION
	g_print( "make_applet\n" );
#endif

	applet = applet_widget_new( PACKAGE );
	if ( !applet )
		g_error( _("Can't create applet!\n" ) );

	style = gtk_widget_get_style( applet );

	init_applet_signals( applet );
	gtk_widget_realize( applet );
	init_pixmaps( style, applet );
	widget = create_applet();

/*	g_free(style);*/

#ifdef HAVE_PANEL_PIXEL_SIZE
	update_orient( applet_widget_get_panel_orient( APPLET_WIDGET( applet ) ),
	               applet_widget_get_panel_pixel_size( APPLET_WIDGET( applet ) ) );
#else
	update_orient( applet_widget_get_panel_orient( APPLET_WIDGET( applet ) ),
	               48 );
#endif

	gtk_widget_show( widget );

	applet_widget_add( APPLET_WIDGET( applet ), widget );

	gtk_widget_show( applet );

	gtk_signal_connect( GTK_OBJECT(applet), "save_session",
	                    GTK_SIGNAL_FUNC(applet_save_state_cb),
	                    NULL);

	gtk_signal_connect( GTK_OBJECT( applet ), "delete_event",
	                    GTK_SIGNAL_FUNC( icq_quit ),
	                    NULL );
}

void applet_update( DWORD status, GdkPixmap *flash )
{
	GdkPixmap *status_pix;
	GdkBitmap *status_bit;
	gchar *message_count = NULL;
	int num_messages = 0;
	gchar *tooltips_str = NULL;
	gint type = 0;
	gint online = 0;

	gchar *names_str = NULL;
	gchar *temp;
   	gchar *status_str;

	GSList *contact;

	gchar *nextmsg = NULL;

	static gchar *old_tooltip = NULL;

#ifdef TRACE_FUNCTION
	g_print("applet_update\n");
#endif

	if( toggles->applet == FALSE )
		return;

	if( status == STATUS_OFFLINE )
	{
		status_pix = icon_offline_pixmap;
		status_bit = icon_offline_bitmap;
	}
	else switch( status & 0xffff )
	{
		case STATUS_ONLINE:
			status_pix = icon_online_pixmap;
			status_bit = icon_online_bitmap;
			break;
		case STATUS_AWAY:
			status_pix = icon_away_pixmap;
			status_bit = icon_away_bitmap;
			break;
		case STATUS_NA:
			status_pix = icon_na_pixmap;
			status_bit = icon_na_bitmap;
			break;
		case STATUS_DND:
			status_pix = icon_dnd_pixmap;
			status_bit = icon_dnd_bitmap;
			break;
		case STATUS_FREE_CHAT:
			status_pix = icon_ffc_pixmap;
			status_bit = icon_ffc_bitmap;
			break;
		case STATUS_OCCUPIED:
			status_pix = icon_occ_pixmap;
			status_bit = icon_occ_bitmap;
			break;
		case STATUS_INVISIBLE:
			status_pix = icon_inv_pixmap;
			status_bit = icon_inv_bitmap;
			break;
		default:
			status_pix = icon_offline_pixmap;
			status_bit = icon_offline_bitmap;
			break;
	}

	contact = Contacts;

	while( contact != NULL )
	{
		if( g_slist_length( kontakt->stored_messages ) && !type ) {
			if( nextmsg == NULL )
				nextmsg = g_strdup_printf( _("Next message from %s"), kontakt->nick );
			type = ((STORED_MESSAGE_PTR)kontakt->stored_messages->data)->type;
		}
		num_messages += g_slist_length( kontakt->stored_messages );
		contact = contact->next;
	}

	if( flash != NULL )
		/* FIXME: I think the correct pixmap is in kontakt already */
		switch( type )
		{
			case MESSAGE_CONT_LIST:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_contact_pixmap,
				                icon_contact_bitmap );
				break;
			case MESSAGE_CHAT_REQ:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_chat_pixmap,
				                icon_chat_bitmap );
				break;
			case MESSAGE_FILE_REQ:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_file_pixmap,
				                icon_file_bitmap );
				break;
			case MESSAGE_URL:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_url_pixmap,
				                icon_url_bitmap );
				break;
			case MESSAGE_AUTH_REQ:
			case MESSAGE_USER_ADD:
			case MESSAGE_USER_AUTHD:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_auth_pixmap,
				                icon_auth_bitmap );
				break;
			default:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_message_pixmap,
				                icon_message_bitmap );
		}

	else if( num_messages )
		gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_blank_pixmap,
		                icon_blank_bitmap );
	else
		gtk_pixmap_set( GTK_PIXMAP( mess_pm ), status_pix,
		                status_bit );

	/* adding code to display contacts in a tooltip, dwb 11-3-1999
	   severely modified by Jeremy Wise, 11-10-1999 */
   	/* Modified even more, by NH, to show status of contact  - NH*/

	contact = Contacts;

	while( contact != NULL )
	{
		if( kontakt->status != STATUS_OFFLINE &&
		    kontakt->ignore_list != TRUE )
		{
			/* Add nick to string */
			temp = names_str;
		   	switch (kontakt->status & 0xffff) {
			case STATUS_ONLINE:
				status_str = _("Online");
				break;
			case STATUS_AWAY:
				status_str = _("Away");
				break;
			case STATUS_NA:
				status_str = _("N/A");
				break;
			case STATUS_FREE_CHAT:
				status_str = _("Free For Chat");
				break;
                        case STATUS_OCCUPIED:
				status_str = _("Occupied");
				break;
                        case STATUS_DND:
				status_str = _("Do Not Disturb");
				break;
                        case STATUS_INVISIBLE:
				status_str = _("Invisible");
				break;
                        default:
				status_str = _("Unknown");
                        }
                        
			/* TODO: better use g_string_append( names_str... ) */
			if( names_str )
				names_str = g_strdup_printf( "%s%s (%s)\n", names_str, kontakt->nick, status_str );
			else
				names_str = g_strdup_printf( "%s (%s)\n", kontakt->nick, status_str );
			g_free( temp );

			online ++;
		}
		contact = contact->next;
	}

	if ( num_messages == 0 )
		message_count = g_strdup_printf( "%d", online );
	else
		message_count = g_strdup_printf( "%d", num_messages );
	gtk_label_set( GTK_LABEL( mess_label ), message_count );
	g_free( message_count );

	if( nextmsg == NULL )
	{
		if( names_str == NULL )
			tooltips_str = g_strdup_printf( _("%u: 0 Users Online"), our_info->uin );
		else if( online == 1 )
			tooltips_str = g_strdup_printf( _("%u: %u User Online\n%s"), our_info->uin, online, names_str );
		else
			tooltips_str = g_strdup_printf( _("%u: %u Users Online\n%s"), our_info->uin, online, names_str );
	}
	else {
		if( names_str == NULL )
			tooltips_str = g_strdup_printf( _("%u: 0 Users Online\n%s"), our_info->uin, nextmsg );
		else if( online == 1 )
			tooltips_str = g_strdup_printf( _("%u: 1 User Online\n%s"), our_info->uin, nextmsg );
		else
			tooltips_str = g_strdup_printf( _("%u: %u Users Online\n%s"), our_info->uin, online, nextmsg );
		g_free( nextmsg );
		nextmsg = NULL;
	}

	g_free( names_str );

        if (!toggles->hidetooltip) 
        {
		if( old_tooltip == NULL || strcmp( tooltips_str, old_tooltip ) )
	                applet_widget_set_tooltip( APPLET_WIDGET( applet ), tooltips_str );
		if( old_tooltip != NULL )
			g_free( old_tooltip );
		old_tooltip = g_strdup( tooltips_str );
        }
        else
        {
                applet_widget_set_tooltip( APPLET_WIDGET( applet ), NULL);
        }

	g_free( tooltips_str );
}

void applet_clicked_cb( GtkWidget *widget, GdkEventButton *ev, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "applet_clicked_cb\n" );
#endif

	if( ev == NULL )
		return;

	if( ev->button != 1 || ev->type != GDK_BUTTON_PRESS )
		return;

	contact = Contacts;

	while( contact != NULL && g_slist_length( kontakt->stored_messages ) == 0 )
		contact = contact->next;

	if( contact == NULL )
		applet_hide_main( widget, NULL );
	else
		show_contact_message( contact );
}

gboolean applet_hide_main( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "applet_hide_main\n" );
#endif

	if( !toggles->applet )
		return TRUE;

        
	if( !GTK_WIDGET_VISIBLE( app ) )
	{
		gtk_widget_show( app );
	}
	else
	{
            if( (gnome_win_hints_get_workspace( app ) != gnome_win_hints_get_current_workspace()) && (GPOINTER_TO_INT(data) == 0))
            {
                gtk_widget_hide( app );
                gdk_window_withdraw( GTK_WIDGET( app )->window );
                gtk_widget_show( app );
            }
            else
            {
                gtk_widget_hide( app );
                gdk_window_withdraw( GTK_WIDGET( app )->window );
                if( autohide_timeout_tag )
                {
                    gtk_timeout_remove( autohide_timeout_tag );
                    /* so we know it's not running anymore */
                    autohide_timeout_tag = 0;
                }
            }
	}
	return TRUE; /* don't emit "destroy" signal */
}

/*** Local functions ***/
gint applet_save_state_cb( GtkWidget *w, const char *privcfgpath, const char *globcfgpath, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "applet_save_state_cb\n");
#endif

	if( have_read_config )
		Save_RC();

	gnome_config_sync();
	gnome_config_drop_all();

	return FALSE;
}

void applet_exposed_cb( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "applet_exposed_cb(%d)\n", Current_Status );
#endif
	applet_update( Current_Status, NULL );
}

GtkWidget *create_applet( void )
{
	GtkWidget *eventbox;

#ifdef TRACE_FUNCTION
	g_print( "create_applet\n" );
#endif

	if( mess_label == NULL )
		mess_label = gtk_label_new( "0" );

	if( mess_pm == NULL )
		mess_pm = gtk_pixmap_new( icon_blank_pixmap, icon_blank_bitmap );

	gtk_widget_push_visual (gdk_imlib_get_visual ());
	gtk_widget_push_colormap (gdk_imlib_get_colormap ());

	eventbox = gtk_event_box_new();
	frame_outline = gtk_frame_new( NULL );

	gtk_container_add( GTK_CONTAINER( eventbox ), frame_outline );
	
	frame = gtk_fixed_new();

	gtk_container_add( GTK_CONTAINER( frame_outline ), frame );
	gtk_frame_set_shadow_type( GTK_FRAME( frame_outline ), GTK_SHADOW_ETCHED_IN );
	gtk_widget_set_usize( frame_outline, 20, 48 );
	gtk_widget_show( frame_outline );

	gtk_widget_show( frame );

	gtk_fixed_put( GTK_FIXED( frame ), mess_pm, 2, 3 );
	gtk_widget_show( mess_pm );

	gtk_misc_set_alignment( GTK_MISC( mess_label ), 0.5, 0.5 );
	gtk_fixed_put( GTK_FIXED( frame ), mess_label, 2, 30 );
	gtk_widget_show( mess_label );

	gtk_widget_pop_colormap ();
	gtk_widget_pop_visual ();
        return eventbox;
}

void init_applet_signals( GtkWidget *window )
{
	gtk_widget_set_events( window, gtk_widget_get_events( window ) |
	                       GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK );

	gtk_signal_connect( GTK_OBJECT( window ), "expose_event",
	                    GTK_SIGNAL_FUNC( applet_exposed_cb ), NULL );

	gtk_signal_connect( GTK_OBJECT( window ), "button_press_event",
	                    GTK_SIGNAL_FUNC( applet_clicked_cb ), NULL );

	gtk_signal_connect( GTK_OBJECT( window ), "change_orient",
	                    GTK_SIGNAL_FUNC( applet_change_orient ), NULL );
#ifdef HAVE_PANEL_PIXEL_SIZE
	gtk_signal_connect( GTK_OBJECT( window ), "change_pixel_size",
			    GTK_SIGNAL_FUNC( applet_change_size ), NULL );
#endif
        applet_widget_register_stock_callback_dir( APPLET_WIDGET( applet ),
                                                   "set_status",
                                                   GNOME_STOCK_MENU_REFRESH,
                                                   _("Change Status") );
        
	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_status/set_online",
	                                       GNOME_STOCK_MENU_BLANK,
	                                       _("Online"),
	                                       (AppletCallbackFunc)icq_set_status_online,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_status/set_away",
	                                       GNOME_STOCK_MENU_BLANK,
	                                       _("Away"),
	                                       (AppletCallbackFunc)icq_set_status_away,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_status/set_na",
	                                       GNOME_STOCK_MENU_BLANK,
	                                       _("Not Available"),
	                                       (AppletCallbackFunc)icq_set_status_na,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_status/set_ffc",
	                                       GNOME_STOCK_MENU_BLANK,
	                                       _("Free For Chat"),
	                                       (AppletCallbackFunc)icq_set_status_ffc,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_status/set_occ",
	                                       GNOME_STOCK_MENU_BLANK,
	                                       _("Occupied"),
	                                       (AppletCallbackFunc)icq_set_status_occ,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_status/set_dnd",
	                                       GNOME_STOCK_MENU_BLANK,
	                                       _("Do Not Disturb"),
	                                       (AppletCallbackFunc)icq_set_status_dnd,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_status/set_inv",
	                                       GNOME_STOCK_MENU_BLANK,
	                                       _("Invisible"),
	                                       (AppletCallbackFunc)icq_set_status_invisible,
	                                       MainData );
        
	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_status/set_offline",
	                                       GNOME_STOCK_MENU_BLANK,
	                                       _("Offline"),
	                                       (AppletCallbackFunc)icq_set_status_offline,
	                                       MainData );
        
	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "options",
	                                       GNOME_STOCK_MENU_PROP,
	                                       _("Preferences..."),
	                                       (AppletCallbackFunc)configure_window,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "about",
	                                       GNOME_STOCK_MENU_BLANK,
	                                       _("About..."),
	                                       (AppletCallbackFunc)about,
	                                       NULL );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "hide_show",
	                                       GNOME_STOCK_MENU_CONVERT,
	                                       _("Hide/Show Main Window"),
	                                       (AppletCallbackFunc)applet_hide_main,
	                                       MainData );
}

static void
update_orient (PanelOrientType orient, int size)
{
	gint x, y, size_minus;

#ifdef TRACE_FUNCTION
        g_print("update_orient orient: %d size: %d\n", orient, size);
#endif

        if (size < 36)
            size_minus = 0;
        else
            size_minus = 4;
        
	if( orient == ORIENT_UP || orient == ORIENT_DOWN )
	{
		if( size < 48 )
		{
			x = 48;
			y = size - size_minus;
		}
		else
		{
			x = 24;
			y = size - size_minus;
		}
	}
	else
	{
		if( size < 48 )
		{
			x = size;
			y = 48;
		}
		else
		{
			x = size;
			y = 24;
		}
	}

	gtk_widget_set_usize( frame, x - size_minus, y - size_minus );
	gtk_widget_set_usize( frame_outline, x, y );
	if( x > y )
		gtk_fixed_move( GTK_FIXED( frame ), mess_label, 30, 2 );
	else
		gtk_fixed_move( GTK_FIXED( frame ), mess_label, 6, 22 );
}

static void applet_change_orient( GtkWidget *w, PanelOrientType o, gpointer data )
{
	int size = 48;
#ifdef HAVE_PANEL_PIXEL_SIZE
	size = applet_widget_get_panel_pixel_size( APPLET_WIDGET( w ) );
#endif
	update_orient( o, size );
}

#ifdef HAVE_PANEL_PIXEL_SIZE
static void applet_change_size( GtkWidget *w, int size, gpointer data )
{
	update_orient( applet_widget_get_panel_orient( APPLET_WIDGET( w )), size );
}
#endif

void applet_remove( void )
{
	applet_widget_remove( APPLET_WIDGET( applet ));
}

void about( GtkWidget *widget, gpointer data )
{
	GtkWidget *about;
	const gchar *authors[] =
	{
		"Jeremy Wise <jwise@pathwaynet.com> (jwise)",
		"David Tabachnikov <captain@isdn.net.il> (nethunter)",
		"As inspired by our Lord Jesus Christ",
		NULL
	};

#ifdef TRACE_FUNCTION
	g_print( "about\n" );
#endif

	about = gnome_about_new( "GnomeICU", VERSION,
	                         "(C) 1999-2001 Jeremy Wise",
	                         authors,
	                         _("GnomeICU is a small, fast and functional "
	                         "clone of Mirabilis' ICQ program, specifically "
	                         "designed for Linux and X."),
	                         NULL );

	gtk_widget_show( about );

	return;
}

/*
 * Mainly stolen from gweather applet...
 */
void
place_widgets ()
{
}
