/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is this file as it was released on
 * May 1 2001.
 *
 * The Initial Developer of the Original Code is Jonas Sicking.
 * Portions created by Jonas Sicking are Copyright (C) 2001
 * Jonas Sicking.  All Rights Reserved.
 *
 * Contributor(s):
 *   Jonas Sicking <sicking@bigfoot.com> (Original Author)
 *
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable
 * instead of those above.  If you wish to allow use of your
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 *
 */
 
#ifndef nsTreeWalker_h___
#define nsTreeWalker_h___

/*
 * nsTreeWalker.h: interface of the nsTreeWalker object.
 */

#include "nsIDOMNode.h"
#include "nsIDOMTreeWalker.h"
#include "nsIDOMNodeFilter.h"
#include "nsCOMPtr.h"

class nsTreeWalker : public nsIDOMTreeWalker
{
public:
    NS_DECL_ISUPPORTS
    NS_DECL_NSIDOMTREEWALKER

    nsTreeWalker(nsIDOMNode *root,
                 PRUint32 whatToShow,
                 nsIDOMNodeFilter *filter,
                 PRBool expandEntityReferences);
    virtual ~nsTreeWalker();
    /* additional members */
private:
    nsCOMPtr<nsIDOMNode> mRoot;
    PRUint32 mWhatToShow;
    nsCOMPtr<nsIDOMNodeFilter> mFilter;
    PRBool mExpandEntityReferences;
    nsCOMPtr<nsIDOMNode> mCurrentNode;

    /*
     * Tests if and how a node should be filtered. Uses mWhatToShow and
     * mFilter to test the node.
     * @param aNode     Node to test
     * @param _filtered Returned filtervalue. See nsIDOMNodeFilter.idl
     */
    nsresult TestNode(nsIDOMNode* aNode, PRInt16* _filtered);

    /*
     * Finds the first child of aNode and returns it. If a child is
     * found, mCurrentNode is set to that child.
     * @param aNode     Node to search for children.
     * @param aReversed Reverses search to find the last child instead
     *                  of first.
     * @param _retval   Returned node. Null if no child is found
     * @returns         Errorcode
     */
    nsresult FirstChildOf(nsIDOMNode* aNode,
                          PRBool aReversed,
                          nsIDOMNode** _retval);

    /*
     * Finds the following sibling of aNode and returns it. If a sibling
     * is found, mCurrentNode is set to that node.
     * @param aNode     Node to start search at.
     * @param aReversed Reverses search to find the previous sibling
     *                  instead of next.
     * @param _retval   Returned node. Null if no sibling is found
     * @returns         Errorcode
     */
    nsresult NextSiblingOf(nsIDOMNode* aNode,
                           PRBool aReversed,
                           nsIDOMNode** _retval);
    /*
     * Finds the next node in document order of aNode and returns it.
     * If a node is found, mCurrentNode is set to that node.
     * @param aNode     Node to start search at.
     * @param aReversed Reverses search to find the preceding node
     *                  instead of next.
     * @param _retval   Returned node. Null if no node is found
     * @returns         Errorcode
     */
    nsresult NextInDocumentOrderOf(nsIDOMNode* aNode,
                                   PRBool aReversed,
                                   nsIDOMNode** _retval);
};

// Make a new nsIDOMTreeWalker object
nsresult NS_NewTreeWalker(nsIDOMNode *root,
                          PRUint32 whatToShow,
                          nsIDOMNodeFilter *filter,
                          PRBool entityReferenceExpansion,
                          nsIDOMTreeWalker **aInstancePtrResult);

#endif