/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __UTIL_IO_H__
#define __UTIL__IOH__

#include <stdio.h>
#include <time.h>

#include <glib.h>

gchar* pan_make_temp (FILE **);

void pan_clean_temp_dir (void);

/**
 * Returns the number of bytes in the file, or 0 on error.
 * @return the number of bytes in the file, or 0 on error.
 * @param filename
 */
size_t get_filesize (const char* filename);

/**
 * Checks to make sure the directory exists.  If it doesn't, directory_check()
 * tries to create it.  If its parent directories don't exist either,
 * directory_check() tries to create them first.
 *
 * @param pathname
 */
void directory_check (const char* pathname);

/**
 * @return a new GArray of lines in the specified file.
 */
GArray* read_file (const char* filename);

gboolean file_exists (const char  * filename);

gchar* pan_normalize_filename_inplace (gchar * filename);

const gchar*
mbox_get_next_message (const gchar * buf,
                       gchar ** setme_from,
                       gchar ** setme_msg);


gchar*
mbox_format_message (const gchar * message,
                     const gchar * author_addr,
                     time_t date);

#endif /* __UTIL_H__ */
