/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * dialog-about.c: About dialog
 */

#include <config.h>
#include <gnome.h>
#include "dialogs.h"
#include "pan-about.h"

static gchar * get_credits_code (void);
static gchar * get_credits_users (void);
static gchar * get_credits_translators (void);

/**
 * dialog_about:
 *
 * About window to display program information, version number, and
 * copyright.
 **/
void
dialog_about (GtkWidget * window)
{
	gchar * pch;
	gchar * credits_bugs;
	gchar * credits_i18n;
	gchar * credits_code;
	GtkWidget * w;
	PanAbout * a;

	static GtkWidget * about = NULL;

	w = pan_about_new ("Pan",
	                   VERSION,
	                   _("A newsreader for GNOME"),
	                   _("Copyright (C) 1999-2001, Pan Development Team"),
	                   PAN_ABOUT_LICENSE_GPL,
	                   "http://pan.rebelbase.com/");

	a = PAN_ABOUT(w);
	pan_about_add_author (a, "Charles Kerr", _("Lead Programmer"), "charles@rebelbase.com");
	pan_about_add_author (a, "Matt Eagleson", _("Programmer & Project Originator"), "e.Messiah@superpimp.org");
	pan_about_add_author (a, "Tov are Jacobsen", _("Translations & PR"), "tovj@stud.ntnu.no");
	pan_about_add_author (a, "Jason Leach", _("Programmer, 0.6 - 0.7"), "elerium@superpimp.org");

	credits_i18n = get_credits_translators ();
	credits_code = get_credits_code ();
	credits_bugs = get_credits_users ();
	pch = g_strdup_printf (_("Many thanks to the following people, whose contributions\n"
	                         "are a large part of why Open Source software development\n"
	                         "is so fun.\n"
                                 "\n"
                                 "Pan %s Translations\n%s\n"
                                 "\n"
                                 "Pan %s Code or Patches\n%s\n"
                                 "\n"
                                 "Pan %s Suggestions and Testing\n%s\n"
                                 "\n"
                                 "If you should have been in this list but you're not,\n"
                                 "send us mail and we'll add you next time.\n"
                                 "\n"
	                         "Contributors to previous versions are listed at\n"
	                         "http://pan.rebelbase.com/CREDITS"),
	                         VERSION, credits_i18n,
	                         VERSION, credits_code,
	                         VERSION, credits_bugs);
	pan_about_add_text (a, _("Thanks"), pch);
	g_free (credits_i18n);
	g_free (credits_code);
	g_free (credits_bugs);
	g_free (pch);

	gtk_signal_connect (GTK_OBJECT(w), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed),
			    &about);

	if (window != NULL)
		gnome_dialog_set_parent (GNOME_DIALOG(w),
					 GTK_WINDOW (window));

	gtk_widget_show (w);
}


static gchar *
get_credits_translators (void)
{
	return g_strdup ("\n\tFinnish - Jarmo Kielosto \n\tFrench - Christophe Merlet \n\tGerman - Christian Meyer \n\tHungarian - Andras Timar \n\tKorean - Nam SungHyun \n\tSlovenian - Andraz Tori \n\tSwedish - Christian Rose \n\tTurkish - Grkem etin \n\tUkranian - Yuri Syrota");

}

static gchar *
get_credits_code (void)
{
	return g_strdup ("\n\tPaolo Bacchilega \n\tJacob Ils Christensen \n\tAdam Huffman \n\tJulien Plissonneau Duquene \n\tNoah Romer \n\tSamuel Solon \n\tTony \"Civ\" \n\tIhar Viarheichyk");
}

static gchar *
get_credits_users (void)
{
	return g_strdup ("\n\tMohit Agarwal \n\tAlan \n\tAnubis \n\tAluminum Foil Ball \n\tSandor Barany \n\tAdrian von Bidder \n\tBrian \n\tBob Broughton \n\tBobby D. Bryant \n\tBudman \n\tDaniel Burrows \n\tJacob Ils Christensen \n\tDuncan Coutts \n\tFrank Van Damme \n\tRyan Daniels \n\tWendell Dingus \n\tGareth \n\tGauze \n\tKen Geis \n\tYura Gusev \n\tDuane Healing \n\tJim Henderson \n\tDave Hill \n\tCory Hill \n\tChristopher Huy \n\tPaul Kleimeyer \n\tSebastien L.  \n\tChristophe Lambin \n\tPer Larsson \n\tJohn J. LeMay Jr.  \n\tStphane Loeuillet \n\tChristian Lohmaier \n\tRMager \n\tCraig Maloney \n\tYosi Markovich \n\tMarkus \n\tLukasz Mikoda \n\tPaulo Filipe Mira \n\tMilton Moura \n\tMuralito \n\tNasa \n\tPeter of the Norse \n\tDavid Oberbeck \n\tAdam Olsen \n\tPete \n\tPhillip Pi \n\tYannick Pollart \n\tMargus Ramst \n\tJoakim Recht \n\tHuub Reuver \n\tKim Robinson \n\tChristian Rose \n\tAndres Salomon \n\tJanus Sandsgaard \n\tAndreas Scherbaum \n\tFlorian Schmidt \n\tWolfgang Schricker \n\tAaron Sethman \n\tAchim Settelmeier \n\tMike Sowka \n\tDietmar Staab \n\tFrederik Vanrenterghem \n\tFilipe Miguel dos Santos Veloza \n\tMichael J. Venables \n\tRon Youvan ");
}
