/*
 * tools/lib/vg_create_remove.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Sistina Software
 *
 * March 1997
 * January 1999
 * January 2000
 * February 2001
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    08/02/2000 - use debug_enter()/debug_leave()
 *    13/02/2001 - use /dev/lvm device rather than /dev/<vg>/group
 *
 */

#include <liblvm.h>

/* internal function */
int vg_create_remove ( char *, vg_t *, int);


int vg_create ( char *vg_name, vg_t *vg) {
   return vg_create_remove ( vg_name, vg, VG_CREATE);
}


int vg_remove ( char *vg_name) {
   return vg_create_remove ( vg_name, NULL, VG_REMOVE);
}


int vg_create_remove ( char *vg_name, vg_t *vg, int cr) {
   int lvm_dev = -1;
   int ret = 0;
	char lvm_dev_name[NAME_LEN];

   debug_enter ( "vg_create_remove -- CALLED\n");

   switch ( cr) {
      case VG_CREATE:
	 strcpy(lvm_dev_name, LVM_DEV);
	 if ( vg_name == NULL ||
              vg == NULL ||
              vg_check_name ( vg_name) < 0 ||
              vg_check_consistency ( vg) < 0) ret = -LVM_EPARAM;
         break;

      case VG_REMOVE:
         sprintf(lvm_dev_name, LVM_DIR_PREFIX "%s/group", vg_name);
         if ( vg_name == NULL ||
              vg_check_name ( vg_name) < 0) ret = -LVM_EPARAM;
         break;

      default:
         ret = -LVM_EPARAM;
   }

   if ( ret == 0) {
      if ( ( lvm_dev = open ( lvm_dev_name, O_RDWR)) == -1)
         ret = -LVM_EVG_CREATE_REMOVE_OPEN;
      else {
         debug ( "vg_create_remove -- IOCTL\n");
         if ( ( ret = ioctl ( lvm_dev, cr, vg)) == -1) ret = -errno;
         debug ( "vg_create_remove -- IOCTL returned: %d\n", ret);
      }
      if ( lvm_dev != -1) close ( lvm_dev);
   }

   debug_leave ( "vg_create_remove -- LEAVING with ret: %d\n", ret);
   return ret;
}
