/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LightweightPeer;
import netscape.applet.AppletServices;
import sun.awt.ScreenUpdater;
import sun.awt.macos.MComponentPeer;
import sun.awt.macos.MPanelPeer;
import sun.awt.macos.MToolkit;

class MFramePeer
extends MPanelPeer
implements FramePeer {
    boolean mFrameIsSecure;
    boolean mFrameIsEmbedded;
    boolean mIsWindow;
    MFramePeer mHostPeer;

    MFramePeer(Frame frame) {
        super(frame);
        Image image;
        Color color;
        Font font;
        this.mIsWindow = false;
        AppletServices.addTopLevelWindow(frame, Thread.currentThread().getThreadGroup());
        if (frame.getTitle() != null) {
            this.setTitle(frame.getTitle());
        }
        if ((font = frame.getFont()) == null) {
            font = new Font("Dialog", 0, 9);
            frame.setFont(font);
            this.setFont(font);
        }
        if ((color = frame.getBackground()) == null) {
            frame.setBackground(Color.lightGray);
            this.setBackground(Color.lightGray);
        }
        if ((color = frame.getForeground()) == null) {
            frame.setForeground(Color.black);
            this.setForeground(Color.black);
        }
        if ((image = frame.getIconImage()) != null) {
            this.setIconImage(image);
        }
        this.setResizable(frame.isResizable());
        Rectangle rectangle = frame.bounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    MFramePeer(Window window) {
        super(window);
        Color color;
        this.mIsWindow = true;
        AppletServices.addTopLevelWindow(window, Thread.currentThread().getThreadGroup());
        Font font = window.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 9);
            window.setFont(font);
            this.setFont(font);
        }
        if ((color = window.getBackground()) == null) {
            window.setBackground(Color.lightGray);
            this.setBackground(Color.lightGray);
        }
        if ((color = window.getForeground()) == null) {
            window.setForeground(Color.black);
            this.setForeground(Color.black);
        }
        this.setResizable(false);
        Rectangle rectangle = window.bounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    native void create(MComponentPeer var1);

    ComponentPeer getFocusPeer() {
        Component component = ((Window)this.target).getFocusOwner();
        while (component != null) {
            ComponentPeer componentPeer = component.getPeer();
            if (componentPeer != null) {
                return componentPeer;
            }
            component = component.getParent();
        }
        return null;
    }

    MComponentPeer setDefaultFocus() {
        Object object;
        Object object2 = this.setDefaultFocus((Container)this.target);
        if (object2 == null) {
            object2 = this.target;
            while (object2 instanceof Container && ((Container)object2).getComponentCount() > 0 && ((Component)object2).getPeer() != null) {
                object = ((Container)object2).getComponent(0);
                if (!((Component)object).isVisible() || !((Component)object).isEnabled()) break;
                object2 = object;
            }
        }
        if ((object = ((Component)object2).getPeer()) instanceof LightweightPeer) {
            ((Component)object2).requestFocus();
            return null;
        }
        return (MComponentPeer)object;
    }

    private Component setDefaultFocus(Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component;
            Component component2 = container.getComponent(n2);
            if (component2.isVisible() && component2.isEnabled() && component2.isFocusTraversable()) {
                return component2;
            }
            if (component2 instanceof Container && component2.isVisible() && component2.isEnabled() && (component = this.setDefaultFocus((Container)component2)) != null) {
                return component;
            }
            ++n2;
        }
        return null;
    }

    protected void sendKeyEvent(int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        Component component = ((Window)this.target).getFocusOwner();
        if (component != null) {
            long l = 0L;
            int n7 = MComponentPeer.modifiersToJavaFlags(n5);
            int n8 = n3;
            char c = (char)n4;
            l = System.currentTimeMillis();
            int n9 = bl ? 401 : 402;
            KeyEvent keyEvent = new KeyEvent(component, n9, l, n7, n8, c);
            MToolkit.addNativeEventInfo(keyEvent, n6);
            MToolkit.postEvent(keyEvent);
            if (bl && c != '\u0000') {
                n9 = 400;
                keyEvent = new KeyEvent(component, n9, l, n7, 0, c);
                MToolkit.addNativeEventInfo(keyEvent, n6);
                MToolkit.postEvent(keyEvent);
            }
        }
    }

    public native void setTitle(String var1);

    public void show() {
        super.show();
        this.pShow();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.pReshape(n, n2, n3, n4);
    }

    public void setIconImage(Image image) {
    }

    public void setMenuBar(MenuBar menuBar) {
    }

    public void setResizable(boolean bl) {
    }

    public void dispose() {
        AppletServices.removeTopLevelWindow((Window)this.target, Thread.currentThread().getThreadGroup());
        MToolkit.targetDisposedPeer(this.target, this);
        ScreenUpdater.updater.removeClient(this);
        this.pDispose();
    }

    private native void pReshape(int var1, int var2, int var3, int var4);

    private native void pDispose();

    private native void pShow();

    protected void handleFrameReshape(int n, int n2, int n3, int n4) {
        this.target.reshape(n, n2, n3, n4);
        this.target.invalidate();
        this.target.validate();
        this.target.repaint();
    }

    protected void handleWindowClose() {
        MToolkit.postEvent(new WindowEvent((Window)this.target, 201));
    }

    protected void handleWindowClosed() {
        MToolkit.postEvent(new WindowEvent((Window)this.target, 202));
    }

    protected void handleWindowActivate() {
        MToolkit.postEvent(new WindowEvent((Window)this.target, 205));
    }

    protected void handleWindowDeactivate() {
        MToolkit.postEvent(new WindowEvent((Window)this.target, 206));
    }

    protected void handleWindowMoved(int n, int n2) {
        MToolkit.postEvent(new ComponentEvent(this.target, 100));
    }

    public native void toFront();

    public native void toBack();
}

