/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsILDAPURL.idl
 */

#ifndef __gen_nsILDAPURL_h__
#define __gen_nsILDAPURL_h__


#ifndef __gen_nsIURI_h__
#include "nsIURI.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsILDAPURL */
#define NS_ILDAPURL_IID_STR "7310562d-1567-43c7-a123-633c1ba3663e"

#define NS_ILDAPURL_IID \
  {0x7310562d, 0x1567, 0x43c7, \
    { 0xa1, 0x23, 0x63, 0x3c, 0x1b, 0xa3, 0x66, 0x3e }}

/**
 * Protocol writers can obtain a very basic (ok, degenerate) implementation
 * of nsIURI by calling the component manager with NS_SIMPLEURI_CID. The
 * implementation returned will only parse things of the form:
 *
 *    about:cache
 *    \   / \   /
 *     ---   ---
 *      |     |
 *   Scheme  Path
 *
 * where the path is everything after the colon. Note that this is probably 
 * only useful for cases like about: or javascript: URIs. 
 *
 * *** What you most likely will want is NS_STANDARDURL_CID which is much more 
 * full featured. Look at nsIURL.idl for more details.
 *
 * NOTE: CIDs are declared in nsNetCID.h
 */
class NS_NO_VTABLE nsILDAPURL : public nsIURI {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ILDAPURL_IID)

  /**
     * the distinguished name of the URL (ie the base DN for the search)
     *
     * for the getter:
     *
     * @exception NS_ERROR_NULL_POINTER     NULL pointer to GET method
     * @exception NS_ERROR_OUT_OF_MEMORY	ran out of memory
     */
  /* attribute string dn; */
  NS_IMETHOD GetDn(char * *aDn) = 0;
  NS_IMETHOD SetDn(const char * aDn) = 0;

  /**
     * the LDAP attributes to return.  defaults to all attributes.
     * This is currently not implemented, and the setter is also
     * missing.
     *
     */
  /* void getAttributes (out unsigned long count, [array, size_is (count), retval] out string values); */
  NS_IMETHOD GetAttributes(PRUint32 *count, char ***values) = 0;

  /**
     * the scope of the search.  defaults to SCOPE_BASE. 
     *
     * @exception NS_ERROR_NULL_POINTER     NULL pointer to GET method
     * @exception NS_ERROR_MALFORMED_URI	Illegal base to SET method
     */
  /* attribute long scope; */
  NS_IMETHOD GetScope(PRInt32 *aScope) = 0;
  NS_IMETHOD SetScope(PRInt32 aScope) = 0;

  /**
     * search just the base object
     */
  enum { SCOPE_BASE = 0 };

  /** 
     * search only the children of the base object
     */
  enum { SCOPE_ONELEVEL = 1 };

  /**
     * search the entire subtree under and including the base object
     */
  enum { SCOPE_SUBTREE = 2 };

  /**
     * the search filter. "(objectClass=*)" is the default.
     */
  /* attribute string filter; */
  NS_IMETHOD GetFilter(char * *aFilter) = 0;
  NS_IMETHOD SetFilter(const char * aFilter) = 0;

  /**
     * any options defined for this URL (check options using a bitwise and)
     * 
     * @exception NS_ERROR_NULL_POINTER     NULL pointer to GET method
     * @exception NS_ERROR_OUT_OF_MEMORY    ran out of memory
     */
  /* attribute unsigned long options; */
  NS_IMETHOD GetOptions(PRUint32 *aOptions) = 0;
  NS_IMETHOD SetOptions(PRUint32 aOptions) = 0;

  /**
     * if this is set/true, this is an ldaps: URL, not an ldap: URL
     */
  enum { OPT_SECURE = 1U };

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSILDAPURL \
  NS_IMETHOD GetDn(char * *aDn); \
  NS_IMETHOD SetDn(const char * aDn); \
  NS_IMETHOD GetAttributes(PRUint32 *count, char ***values); \
  NS_IMETHOD GetScope(PRInt32 *aScope); \
  NS_IMETHOD SetScope(PRInt32 aScope); \
  NS_IMETHOD GetFilter(char * *aFilter); \
  NS_IMETHOD SetFilter(const char * aFilter); \
  NS_IMETHOD GetOptions(PRUint32 *aOptions); \
  NS_IMETHOD SetOptions(PRUint32 aOptions); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSILDAPURL(_to) \
  NS_IMETHOD GetDn(char * *aDn) { return _to ## GetDn(aDn); } \
  NS_IMETHOD SetDn(const char * aDn) { return _to ## SetDn(aDn); } \
  NS_IMETHOD GetAttributes(PRUint32 *count, char ***values) { return _to ## GetAttributes(count, values); } \
  NS_IMETHOD GetScope(PRInt32 *aScope) { return _to ## GetScope(aScope); } \
  NS_IMETHOD SetScope(PRInt32 aScope) { return _to ## SetScope(aScope); } \
  NS_IMETHOD GetFilter(char * *aFilter) { return _to ## GetFilter(aFilter); } \
  NS_IMETHOD SetFilter(const char * aFilter) { return _to ## SetFilter(aFilter); } \
  NS_IMETHOD GetOptions(PRUint32 *aOptions) { return _to ## GetOptions(aOptions); } \
  NS_IMETHOD SetOptions(PRUint32 aOptions) { return _to ## SetOptions(aOptions); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSILDAPURL(_to) \
  NS_IMETHOD GetDn(char * *aDn) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDn(aDn); } \
  NS_IMETHOD SetDn(const char * aDn) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetDn(aDn); } \
  NS_IMETHOD GetAttributes(PRUint32 *count, char ***values) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetAttributes(count, values); } \
  NS_IMETHOD GetScope(PRInt32 *aScope) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetScope(aScope); } \
  NS_IMETHOD SetScope(PRInt32 aScope) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetScope(aScope); } \
  NS_IMETHOD GetFilter(char * *aFilter) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetFilter(aFilter); } \
  NS_IMETHOD SetFilter(const char * aFilter) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetFilter(aFilter); } \
  NS_IMETHOD GetOptions(PRUint32 *aOptions) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetOptions(aOptions); } \
  NS_IMETHOD SetOptions(PRUint32 aOptions) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetOptions(aOptions); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsLDAPURL : public nsILDAPURL
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSILDAPURL

  nsLDAPURL();
  virtual ~nsLDAPURL();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsLDAPURL, nsILDAPURL)

nsLDAPURL::nsLDAPURL()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsLDAPURL::~nsLDAPURL()
{
  /* destructor code */
}

/* attribute string dn; */
NS_IMETHODIMP nsLDAPURL::GetDn(char * *aDn)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLDAPURL::SetDn(const char * aDn)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getAttributes (out unsigned long count, [array, size_is (count), retval] out string values); */
NS_IMETHODIMP nsLDAPURL::GetAttributes(PRUint32 *count, char ***values)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long scope; */
NS_IMETHODIMP nsLDAPURL::GetScope(PRInt32 *aScope)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLDAPURL::SetScope(PRInt32 aScope)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string filter; */
NS_IMETHODIMP nsLDAPURL::GetFilter(char * *aFilter)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLDAPURL::SetFilter(const char * aFilter)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long options; */
NS_IMETHODIMP nsLDAPURL::GetOptions(PRUint32 *aOptions)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsLDAPURL::SetOptions(PRUint32 aOptions)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsILDAPURL_h__ */
