/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIInputStream.idl
 */

#ifndef __gen_nsIInputStream_h__
#define __gen_nsIInputStream_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIInputStream; /* forward declaration */

class nsIInputStreamObserver; /* forward declaration */

/**
 * The signature of the writer function passed to ReadSegments. This
 * specifies where the data should go that gets read from the buffer.
 * Implementers should return the following:
 * @return NS_OK and writeCount - if successfully wrote something
 * @return NS_BASE_STREAM_CLOSED - if no more can be written
 * @return NS_BASE_STREAM_WOULD_BLOCK - if there is currently space to write (in
 *   a non-blocking mode)
 * @return <other-error> - on failure
 */
typedef NS_CALLBACK(nsWriteSegmentFun)(nsIInputStream* in,
                                       void* closure,
                                       const char* fromRawSegment,
                                       PRUint32 toOffset,
                                       PRUint32 count,
                                       PRUint32 *writeCount);

/* starting interface:    nsIInputStream */
#define NS_IINPUTSTREAM_IID_STR "fa9c7f6c-61b3-11d4-9877-00c04fa0cf4a"

#define NS_IINPUTSTREAM_IID \
  {0xfa9c7f6c, 0x61b3, 0x11d4, \
    { 0x98, 0x77, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a }}

class NS_NO_VTABLE nsIInputStream : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IINPUTSTREAM_IID)

  /** 
     * Closes the stream. 
     */
  /* void close (); */
  NS_IMETHOD Close(void) = 0;

  /**
     * Return the number of bytes currently available in the stream
     * @param aLength out parameter to hold the number of bytes
     *        if an error occurs, the parameter will be undefined
     * @return error status
     */
  /* unsigned long available (); */
  NS_IMETHOD Available(PRUint32 *_retval) = 0;

  /** 
     * Read data from the stream.
     * @param aBuf the buffer into which the data is read
     * @param aCount the maximum number of bytes to read
     * @return aReadCount out parameter to hold the number of
     *        bytes read, eof if 0. if an error occurs, the
     *        read count will be undefined
     */
  /* [noscript] unsigned long read (in charPtr buf, in unsigned long count); */
  NS_IMETHOD Read(char * buf, PRUint32 count, PRUint32 *_retval) = 0;

  /**
     * Low-level read method that has access to the stream's underlying buffer. The
     * writer function may be called multiple times for segmented buffers.
     */
  /* [noscript] unsigned long readSegments (in nsWriteSegmentFun writer, in voidPtr closure, in unsigned long count); */
  NS_IMETHOD ReadSegments(nsWriteSegmentFun writer, void * closure, PRUint32 count, PRUint32 *_retval) = 0;

  /**
     * Set this attribute to put the stream in non-blocking mode.
     */
  /* readonly attribute boolean nonBlocking; */
  NS_IMETHOD GetNonBlocking(PRBool *aNonBlocking) = 0;

  /**
     * Allows users to set an observer on an input stream to receive notifications
     * about the consumer emptying the input stream's underlying buffer, or closing the
     * stream. This is necessary for non-blocking streams so that the producer can suspend
     * itself until more data can be written.
     */
  /* attribute nsIInputStreamObserver observer; */
  NS_IMETHOD GetObserver(nsIInputStreamObserver * *aObserver) = 0;
  NS_IMETHOD SetObserver(nsIInputStreamObserver * aObserver) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIINPUTSTREAM \
  NS_IMETHOD Close(void); \
  NS_IMETHOD Available(PRUint32 *_retval); \
  NS_IMETHOD Read(char * buf, PRUint32 count, PRUint32 *_retval); \
  NS_IMETHOD ReadSegments(nsWriteSegmentFun writer, void * closure, PRUint32 count, PRUint32 *_retval); \
  NS_IMETHOD GetNonBlocking(PRBool *aNonBlocking); \
  NS_IMETHOD GetObserver(nsIInputStreamObserver * *aObserver); \
  NS_IMETHOD SetObserver(nsIInputStreamObserver * aObserver); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIINPUTSTREAM(_to) \
  NS_IMETHOD Close(void) { return _to ## Close(); } \
  NS_IMETHOD Available(PRUint32 *_retval) { return _to ## Available(_retval); } \
  NS_IMETHOD Read(char * buf, PRUint32 count, PRUint32 *_retval) { return _to ## Read(buf, count, _retval); } \
  NS_IMETHOD ReadSegments(nsWriteSegmentFun writer, void * closure, PRUint32 count, PRUint32 *_retval) { return _to ## ReadSegments(writer, closure, count, _retval); } \
  NS_IMETHOD GetNonBlocking(PRBool *aNonBlocking) { return _to ## GetNonBlocking(aNonBlocking); } \
  NS_IMETHOD GetObserver(nsIInputStreamObserver * *aObserver) { return _to ## GetObserver(aObserver); } \
  NS_IMETHOD SetObserver(nsIInputStreamObserver * aObserver) { return _to ## SetObserver(aObserver); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIINPUTSTREAM(_to) \
  NS_IMETHOD Close(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Close(); } \
  NS_IMETHOD Available(PRUint32 *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Available(_retval); } \
  NS_IMETHOD Read(char * buf, PRUint32 count, PRUint32 *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Read(buf, count, _retval); } \
  NS_IMETHOD ReadSegments(nsWriteSegmentFun writer, void * closure, PRUint32 count, PRUint32 *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ReadSegments(writer, closure, count, _retval); } \
  NS_IMETHOD GetNonBlocking(PRBool *aNonBlocking) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetNonBlocking(aNonBlocking); } \
  NS_IMETHOD GetObserver(nsIInputStreamObserver * *aObserver) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetObserver(aObserver); } \
  NS_IMETHOD SetObserver(nsIInputStreamObserver * aObserver) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetObserver(aObserver); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsInputStream : public nsIInputStream
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIINPUTSTREAM

  nsInputStream();
  virtual ~nsInputStream();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsInputStream, nsIInputStream)

nsInputStream::nsInputStream()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsInputStream::~nsInputStream()
{
  /* destructor code */
}

/* void close (); */
NS_IMETHODIMP nsInputStream::Close()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long available (); */
NS_IMETHODIMP nsInputStream::Available(PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] unsigned long read (in charPtr buf, in unsigned long count); */
NS_IMETHODIMP nsInputStream::Read(char * buf, PRUint32 count, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] unsigned long readSegments (in nsWriteSegmentFun writer, in voidPtr closure, in unsigned long count); */
NS_IMETHODIMP nsInputStream::ReadSegments(nsWriteSegmentFun writer, void * closure, PRUint32 count, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean nonBlocking; */
NS_IMETHODIMP nsInputStream::GetNonBlocking(PRBool *aNonBlocking)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIInputStreamObserver observer; */
NS_IMETHODIMP nsInputStream::GetObserver(nsIInputStreamObserver * *aObserver)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsInputStream::SetObserver(nsIInputStreamObserver * aObserver)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIInputStreamObserver */
#define NS_IINPUTSTREAMOBSERVER_IID_STR "019d67cc-61b4-11d4-9877-00c04fa0cf4a"

#define NS_IINPUTSTREAMOBSERVER_IID \
  {0x019d67cc, 0x61b4, 0x11d4, \
    { 0x98, 0x77, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a }}

class NS_NO_VTABLE nsIInputStreamObserver : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IINPUTSTREAMOBSERVER_IID)

  /**
     * Called when the input stream's consumer has read all the existing data from the stream.
     */
  /* void onEmpty (in nsIInputStream outStr); */
  NS_IMETHOD OnEmpty(nsIInputStream *outStr) = 0;

  /**
     * Called when the consumer closes its end of the stream.
     */
  /* void onClose (in nsIInputStream outStr); */
  NS_IMETHOD OnClose(nsIInputStream *outStr) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIINPUTSTREAMOBSERVER \
  NS_IMETHOD OnEmpty(nsIInputStream *outStr); \
  NS_IMETHOD OnClose(nsIInputStream *outStr); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIINPUTSTREAMOBSERVER(_to) \
  NS_IMETHOD OnEmpty(nsIInputStream *outStr) { return _to ## OnEmpty(outStr); } \
  NS_IMETHOD OnClose(nsIInputStream *outStr) { return _to ## OnClose(outStr); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIINPUTSTREAMOBSERVER(_to) \
  NS_IMETHOD OnEmpty(nsIInputStream *outStr) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OnEmpty(outStr); } \
  NS_IMETHOD OnClose(nsIInputStream *outStr) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OnClose(outStr); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsInputStreamObserver : public nsIInputStreamObserver
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIINPUTSTREAMOBSERVER

  nsInputStreamObserver();
  virtual ~nsInputStreamObserver();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsInputStreamObserver, nsIInputStreamObserver)

nsInputStreamObserver::nsInputStreamObserver()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsInputStreamObserver::~nsInputStreamObserver()
{
  /* destructor code */
}

/* void onEmpty (in nsIInputStream outStr); */
NS_IMETHODIMP nsInputStreamObserver::OnEmpty(nsIInputStream *outStr)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onClose (in nsIInputStream outStr); */
NS_IMETHODIMP nsInputStreamObserver::OnClose(nsIInputStream *outStr)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIInputStream_h__ */
