/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIContextMenuListener.idl
 */

#ifndef __gen_nsIContextMenuListener_h__
#define __gen_nsIContextMenuListener_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMEvent; /* forward declaration */

class nsIDOMNode; /* forward declaration */


/* starting interface:    nsIContextMenuListener */
#define NS_ICONTEXTMENULISTENER_IID_STR "3478b6b0-3875-11d4-94ef-0020183bf181"

#define NS_ICONTEXTMENULISTENER_IID \
  {0x3478b6b0, 0x3875, 0x11d4, \
    { 0x94, 0xef, 0x00, 0x20, 0x18, 0x3b, 0xf1, 0x81 }}

/**
 * The nsIContextMenuListener interface is called on embedding clients when
 * a context menu should be displayed.
 *
 * @status UNDER_REVIEW
 */
class NS_NO_VTABLE nsIContextMenuListener : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ICONTEXTMENULISTENER_IID)

  enum { CONTEXT_NONE = 0U };

  enum { CONTEXT_LINK = 1U };

  enum { CONTEXT_IMAGE = 2U };

  enum { CONTEXT_DOCUMENT = 4U };

  enum { CONTEXT_TEXT = 8U };

  enum { CONTEXT_INPUT = 16U };

  /**
     * Called when the user attempts to display a context menu, e.g. by
     * right-clicking on a link. The combination of flags indicates what was
     * clicked on, the DOM event and node objects allow the client to interrogate
     * for more information if they like.
     *
     * The following table describes what aNode points two given a particular
     * aContextFlag. No other combinations are possible.
     *
     * aContextFlag                  |  aNode
     * ------------------------------+-----------------
     * CONTEXT_LINK                  |  <A>
     * CONTEXT_IMAGE                 |  <IMG>
     * CONTEXT_IMAGE | CONTEXT_LINK  |  <IMG> *
     * CONTEXT_INPUT                 |  <INPUT>
     * CONTEXT_TEXT                  |  <TEXTAREA>
     * CONTEXT_DOCUMENT              |  <HTML>
     *
     * * <A> node is guaranteed to be an ancestor of this node
     *
     */
  /* void OnShowContextMenu (in unsigned long aContextFlags, in nsIDOMEvent aEvent, in nsIDOMNode aNode); */
  NS_IMETHOD OnShowContextMenu(PRUint32 aContextFlags, nsIDOMEvent *aEvent, nsIDOMNode *aNode) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICONTEXTMENULISTENER \
  NS_IMETHOD OnShowContextMenu(PRUint32 aContextFlags, nsIDOMEvent *aEvent, nsIDOMNode *aNode); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICONTEXTMENULISTENER(_to) \
  NS_IMETHOD OnShowContextMenu(PRUint32 aContextFlags, nsIDOMEvent *aEvent, nsIDOMNode *aNode) { return _to ## OnShowContextMenu(aContextFlags, aEvent, aNode); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICONTEXTMENULISTENER(_to) \
  NS_IMETHOD OnShowContextMenu(PRUint32 aContextFlags, nsIDOMEvent *aEvent, nsIDOMNode *aNode) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OnShowContextMenu(aContextFlags, aEvent, aNode); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsContextMenuListener : public nsIContextMenuListener
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSICONTEXTMENULISTENER

  nsContextMenuListener();
  virtual ~nsContextMenuListener();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsContextMenuListener, nsIContextMenuListener)

nsContextMenuListener::nsContextMenuListener()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsContextMenuListener::~nsContextMenuListener()
{
  /* destructor code */
}

/* void OnShowContextMenu (in unsigned long aContextFlags, in nsIDOMEvent aEvent, in nsIDOMNode aNode); */
NS_IMETHODIMP nsContextMenuListener::OnShowContextMenu(PRUint32 aContextFlags, nsIDOMEvent *aEvent, nsIDOMNode *aNode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIContextMenuListener_h__ */
