#!/bin/sh
#
# /etc/rc.d/rc.S:  System initialization script.
#
# Mostly written by:  Patrick J. Volkerding, <volkerdi@slackware.com>
#

PATH=/sbin:/usr/sbin:/bin:/usr/bin

# Start devfsd if necessary
if [ -r /dev/.devfsd ]; then
  if [ -x /sbin/devfsd ]; then
    echo "Starting devfs daemon:  /sbin/devfsd /dev"
    /sbin/devfsd /dev
  fi
fi

# enable swapping
/sbin/swapon -a

# Start update.
/sbin/update &

# Test to see if the root partition is read-only, like it ought to be.
READWRITE=no
if echo -n >> "Testing filesystem status"; then
  rm -f "Testing filesystem status"
  READWRITE=yes
fi

# Check the integrity of all filesystems
if [ ! $READWRITE = yes ]; then
  /sbin/fsck -A -a
  # If there was a failure, drop into single-user mode.
  if [ $? -gt 1 ] ; then
    echo
    echo
    echo "*******************************************************"
    echo "*** An error occurred during the file system check. ***"
    echo "*** You will now be given a chance to log into the  ***"
    echo "*** system in single-user mode to fix the problem.  ***"
    echo "*** Running 'e2fsck -v -y <partition>' might help.  ***"
    echo "*******************************************************"
    echo
    echo "Once you exit the single-user shell, the system will reboot."
    echo

    PS1="(Repair filesystem) \#"; export PS1
    sulogin

    echo "Unmounting file systems."
    umount -a -r
    mount -n -o remount,ro /
    echo "Rebooting system."
    sleep 2
    reboot
  fi
  # Remount the root filesystem in read-write mode
  echo "Remounting root device with read-write enabled."
  /sbin/mount -w -v -n -o remount /
  if [ $? -gt 0 ] ; then
    echo
    echo "Attempt to remount root device as read-write failed!  This is going to"
    echo "cause serious problems."
    echo 
    echo "If you're using the UMSDOS filesystem, you **MUST** mount the root partition"
    echo "read-write!  You can make sure the root filesystem is getting mounted "
    echo "read-write with the 'rw' flag to Loadlin:"
    echo
    echo "loadlin vmlinuz root=/dev/hda1 rw   (replace /dev/hda1 with your root device)"
    echo
    echo "Normal bootdisks can be made to mount a system read-write with the rdev command:"
    echo
    echo "rdev -R /dev/fd0 0"
    echo
    echo "You can also get into your system by using a bootkernel disk with a command"
    echo "like this on the LILO prompt line:  (change the root partition name as needed)"
    echo 
    echo "LILO: mount root=/dev/hda1 rw"
    echo
    echo "Please press ENTER to continue, then reboot and use one of the above methods to"
    echo -n "get into your machine and start looking for the problem. " 
    read junk; 
  fi
else
  echo "Testing filesystem status: read-write filesystem"
  if cat /etc/fstab | grep ' / ' | grep umsdos 1> /dev/null 2> /dev/null ; then
    ROOTTYPE="umsdos"
  fi
  if [ ! "$ROOTTYPE" = "umsdos" ]; then # no warn for UMSDOS
    cat << EOF

*** ERROR: Root partition has already been mounted read-write. Cannot check!

For filesystem checking to work properly, your system must initially mount
the root partition as read only. Please modify your kernel with 'rdev' so that
it does this. If you're booting with LILO, add a line:

   read-only

to the Linux section in your /etc/lilo.conf and type 'lilo' to reinstall it.

If you boot from a kernel on a floppy disk, put it in the drive and type:
  rdev -R /dev/fd0 1

If you boot from a bootkernel disk, or with Loadlin, you can add the 'ro' flag.

This will fix the problem *AND* eliminate this annoying message. :^)

EOF
    echo -n "Press ENTER to continue. "
    read junk;
  fi
fi

# remove /etc/mtab* so that mount will create it with a root entry
/bin/rm -f /etc/mtab* /etc/nologin /etc/shutdownpid 

# mount file systems in fstab (and create an entry for /)
# but not NFS or SMB because TCP/IP is not yet configured
/sbin/mount -a -v -t nonfs,nosmbfs

# Clean up temporary files on the /var volume:
/bin/rm -f /var/run/utmp /var/run/*.pid /var/log/setup/tmp/*

# Looks like we have to create this.
cat /dev/null > /var/run/utmp

# Detect SGI Visual Workstation, since hwclock will make those freeze up:
if fgrep -l Cobalt-APIC /proc/interrupts 1> /dev/null 2> /dev/null ; then
  echo "SGI Visual Workstation detected.  Not running hwclock."
# Set the system time from the hardware clock using hwclock
elif [ -x /sbin/hwclock ]; then
  echo "Setting system time from hardware clock."
  if [ -e /etc/hardwareclock ]; then
    HC=`cat /etc/hardwareclock | while read LINE ; do
      if [ "$LINE" = "UTC" -o "$LINE" = "utc" ]; then
        echo utc
        break;
      elif [ "$LINE" = "localtime" ]; then
        echo localtime
        break;
      fi
    done`
  else
    # Default to localtime if there is no /etc/hardwareclock:
    HC=localtime
  fi
  # /sbin/hwclock --$HC --hctosys
  # The line above *should* work with --localtime, but doesn't.  Omitting
  # the argument defaults it to localtime, so use that.
  if [ "$HC" = "utc" ]; then
    /sbin/hwclock --utc --hctosys
  else
    /sbin/hwclock --hctosys
  fi
fi

if [ "$ROOTTYPE" = "umsdos" ]; then # we need to update any files added in DOS:
  echo "Synchronizing UMSDOS directory structure:"
  echo "  umssync -r99 -v- /"
  umssync -r99 -v- /
fi

# Setup the /etc/motd to reflect the current kernel level:
# THIS WIPES ANY CHANGES YOU MAKE TO /ETC/MOTD WITH EACH BOOT.
# COMMENT THIS OUT IF YOU WANT TO MAKE A CUSTOM VERSION.
echo "`/bin/uname -a | /bin/cut -d\  -f1,3`." > /etc/motd

# Configure ISA Plug-and-Play devices:
if [ -r /etc/isapnp.conf ]; then
  if [ -x /sbin/isapnp ]; then
    /sbin/isapnp /etc/isapnp.conf
  fi
fi

# This loads any kernel modules that are needed.  These might be required to
# use your CD-ROM drive, bus mouse, ethernet card, or other optional hardware.
if [ -x /etc/rc.d/rc.modules ]; then
  . /etc/rc.d/rc.modules
fi

# Initialize PCMCIA devices:
#
# NOTE: This had been closer to the top of this script so that PCMCIA devices
# could be fsck'ed along with the other drives.  This had some unfortunate
# side effects, however, since root isn't yet read-write, and /var might not
# even be mounted the .pid files can't be correctly written in /var/run and
# the pcmcia system can't be correctly shut down.  If you want some PCMCIA
# partition to be mounted at boot (or when the card is inserted) then add
# the appropriate lines to /etc/pcmcia/scsi.opts.
#
if [ -x /etc/rc.d/rc.pcmcia ] ; then
  . /etc/rc.d/rc.pcmcia start
fi

# Run serial port setup script:
# (CAREFUL! This can make some systems hang if the rc.serial script isn't
# set up correctly. If this happens, you may have to edit the file from a
# boot disk)
#
# . /etc/rc.d/rc.serial

# Carry an entropy pool between reboots to improve randomness.
# Load and then save 512 bytes, which is the size of the entropy pool.
if [ -f /etc/random-seed ]; then
  echo "Using /etc/random-seed to initialize /dev/urandom."
  cat /etc/random-seed >/dev/urandom
fi
dd if=/dev/urandom of=/etc/random-seed count=1 bs=512 2> /dev/null

