/*
 * Copyright 1999 Silicon Graphics, Inc.
 */
#ifndef _SPB_H_
#define _SPB_H_

#include "types.h"
#include "arc.h"

#ifdef __GNUC__
#define CDECL	__attribute__ ((cdecl))
#else /* __GNUC__ */
#define CDECL
#endif /* __GNUC__ */

typedef struct {
    LONG (*Load)(CHAR *, ULONG, ULONG *, ULONG *) CDECL;
    LONG (*Invoke)(ULONG, ULONG, ULONG, CHAR *[], CHAR *[]) CDECL;
    LONG (*Execute)(CHAR *, ULONG, CHAR *[], CHAR *[]) CDECL;
    VOID (*Halt)(VOID) CDECL;
    VOID (*PowerDown)(VOID) CDECL;
    VOID (*Restart)(VOID) CDECL;
    VOID (*Reboot)(VOID) CDECL;
    VOID (*EnterInteractiveMode)(VOID) CDECL;
    VOID *reserved1;
    COMPONENT * (*GetPeer)(COMPONENT *) CDECL;
    COMPONENT * (*GetChild)(COMPONENT *) CDECL;
    COMPONENT * (*GetParent)(COMPONENT *) CDECL;
    LONG (*GetConfigurationData)(VOID *, COMPONENT *) CDECL;
    COMPONENT * (*AddChild)(COMPONENT *, COMPONENT *, VOID *) CDECL;
    LONG (*DeleteComponent)(COMPONENT *) CDECL;
    COMPONENT * (*GetComponent)(CHAR *) CDECL;
    LONG (*SaveConfiguration)(VOID) CDECL;
    SYSTEMID * (*GetSystemId)(VOID) CDECL;
    MEMORYDESCRIPTOR * (*GetMemoryDescriptor)(MEMORYDESCRIPTOR *) CDECL;
    VOID *reserved2;
    TIMEINFO * (*GetTime)(VOID) CDECL;
    ULONG (*GetRelativeTime)(VOID) CDECL;
    LONG (*GetDirectoryEntry)(ULONG, DIRECTORYENTRY *, ULONG, ULONG *) CDECL;
    LONG (*Open)(CHAR *, OPENMODE, ULONG *) CDECL;
    LONG (*Close)(ULONG) CDECL;
    LONG (*Read)(ULONG, VOID *, ULONG, ULONG *) CDECL;
    LONG (*GetReadStatus)(ULONG) CDECL;
    LONG (*Write)(ULONG, VOID *, ULONG, ULONG *) CDECL;
    LONG (*Seek)(ULONG, LARGEINTEGER *, SEEKMODE) CDECL;
    LONG (*Mount)(CHAR *, MOUNTOPERATION) CDECL;
    CHAR * (*GetEnvironmentVariable)(CHAR *) CDECL;
    LONG (*SetEnvironmentVariable)(CHAR *, CHAR *) CDECL;
    LONG (*GetFileInformation)(ULONG, FILEINFORMATION *) CDECL;
    LONG (*SetFileInformation)(ULONG, ULONG, ULONG) CDECL;
    VOID (*FlushAllCaches)(VOID) CDECL;
    LONG (*TestUnicodeCharacter)(ULONG, USHORT) CDECL;
    DISPLAY_STATUS * (*GetDisplayStatus)(ULONG) CDECL;
} FIRMWAREVECTOR;

#define RSTB_SIGNATURE	0x42545352

typedef struct _rstb {
    ULONG		RSTBSignature;
    ULONG		RSTBLength;
    USHORT		Version;
    USHORT		Revision;
    struct _rstb	*NextRSTB;
    VOID		*RestartAddress;
    ULONG		BootMasterID;
    ULONG		ProcessorID;
    ULONG		BootStatus;
    ULONG		Checksum;
    ULONG		SaveAreaLength;
    ULONG		SavedStateArea[1];
} RESTARTBLOCK;

typedef struct {
    ULONG	AdapterType;
    ULONG	AdapterVectorLength;
    VOID	*AdapterVector;
} ADAPTER;

#define SPB_SIGNATURE	0x53435241

typedef struct {
    ULONG		SPBSignature;
    ULONG		SPBLength;
    USHORT		Version;
    USHORT		Revision;
    RESTARTBLOCK	*RestartBlock;
    VOID		*DebugBlock;
    VOID		*GEVector;
    VOID		*UTLBMissVector;
    ULONG		FirmwareVectorLength;
    FIRMWAREVECTOR	*FirmwareVector;
    ULONG		PrivateVectorLength;
    VOID		*PrivateVector;
    ULONG		AdapterCount;
    ADAPTER		Adapters[1];
} SPB;

#define SystemParameterBlock	((SPB *) 0x1000)
#define FVector		(SystemParameterBlock->FirmwareVector)

#endif /* _SPB_H_ */
