/*
 * Copyright 1999 Silicon Graphics, Inc.
 */
#include <stdarg.h>

#include "stdio.h"
#include "stddef.h"
#include "types.h"
#include "arc.h"

void
Wait(const char *prompt)
{
    int ch;

    if (prompt != NULL)
	puts(prompt);

    do {
	ch = getchar();
    } while ((ch != EOF) && (((char)ch) != ' '));
}

void
Fatal(const CHAR *message, ...)
{
    va_list ap;

    if (message != NULL) {
	printf("FATAL ERROR:  ");
	va_start(ap, message);
	vprintf(message, ap);
	va_end(ap);
    }

    Wait("\n--- Press <spacebar> to enter ARC interactive mode ---");
    ArcEnterInteractiveMode();
}
