# Makefile for core library for VMS
# contributed by Jouk Jansen  joukj@crys.chem.uva.nl
# Last revision : 3 May 1999

.first
	define gl [-.include.gl]

.include [-]mms-config.

##### MACROS #####

VPATH = RCS

INCDIR = [-.include]
LIBDIR = [-.lib]
CFLAGS = /include=($(INCDIR),[])/define=(FBIND=1)

CORE_SOURCES = aatriangle.c accum.c alpha.c alphabuf.c attrib.c \
bitmap.c blend.c buffers.c clip.c colortab.c context.c copypix.c depth.c \
dispatch.c \
dlist.c drawpix.c enable.c eval.c feedback.c fog.c \
get.c hash.c hint.c image.c imaging.c light.c lines.c logic.c masking.c matrix.c \
mem.c glapi.c glapinoop.c \
mmath.c pb.c pixel.c points.c polygon.c \
quads.c rastpos.c readpix.c rect.c scissor.c shade.c span.c \
stencil.c teximage.c texobj.c texstate.c texture.c translate.c triangle.c \
varray.c winpos.c vb.c vbcull.c vbfill.c vbrender.c vbxform.c xform.c \
zoom.c bbox.c cva.c vector.c vbindirect.c config.c enums.c extensions.c \
pipeline.c stages.c state.c vertices.c [.x86]x86.c

DRIVER_SOURCES = [.x]glxapi.c [.x]fakeglx.c [.x]xfonts.c \
[.x]xmesa1.c [.x]xmesa2.c [.x]xmesa3.c [.x]xmesa4.c \
[.osmesa]osmesa.c \
[.svga]svgamesa.c \
[.fx]fxapi.c [.fx]fxdd.c [.fx]fxddtex.c [.fx]fxvsetup.c [.fx]fxsetup.c \
[.fx]fxtrifuncs.c [.fx]fxclip.c [.fx]fxfastpath.c [.fx]fxpipeline.c\
[.fx]fxrender.c [.fx]fxtexman.c [.fx]fxddspan.c [.fx]fxcva.c [.fx]fxsanity.c\
[.fx]fxglidew.c

ASM_SOURCES =

OBJECTS =aatriangle.obj,\
accum.obj,alpha.obj,alphabuf.obj,attrib.obj,\
bitmap.obj,blend.obj,buffers.obj,clip.obj,colortab.obj,context.obj,copypix.obj,depth.obj,\
dlist.obj,drawpix.obj,enable.obj,eval.obj,feedback.obj,fog.obj


OBJECTS3=get.obj,hash.obj,hint.obj,image.obj,light.obj,lines.obj,logic.obj,masking.obj,\
matrix.obj,glapi.obj,glapinoop.obj,dispatch.obj,imaging.obj,mem.obj,\
mmath.obj,pb.obj,pixel.obj,points.obj

OBJECTS7=polygon.obj,\
quads.obj,rastpos.obj,readpix.obj,rect.obj,scissor.obj,shade.obj,span.obj,\
pixeltex.obj

OBJECTS4=stencil.obj,teximage.obj,texobj.obj,texstate.obj,texture.obj,translate.obj,\
triangle.obj,varray.obj,winpos.obj,vb.obj,vbcull.obj,vbfill.obj,vbrender.obj

OBJECTS6=vbxform.obj,xform.obj,zoom.obj,bbox.obj,cva.obj,vector.obj,vbindirect.obj,\
	config.obj,enums.obj,extensions.obj,pipeline.obj,stages.obj,state.obj,\
	vertices.obj,[.x86]x86.obj

OBJECTS2=[.x]glxapi.obj,[.x]fakeglx.obj,[.x]xfonts.obj,\
[.x]xmesa1.obj,[.x]xmesa2.obj,[.x]xmesa3.obj,[.x]xmesa4.obj,\
[.osmesa]osmesa.obj,\
[.svga]svgamesa.obj

OBJECTS5=[.fx]fxapi.obj,[.fx]fxdd.obj,[.fx]fxddtex.obj,[.fx]fxvsetup.obj,\
[.fx]fxsetup.obj,[.fx]fxclip.obj,[.fx]fxfastpath.obj,[.fx]fxpipeline.obj

OBJECTS8=[.fx]fxtrifuncs.obj,[.fx]fxsanity.obj,[.fx]fxglidew.obj,\
[.fx]fxrender.obj,[.fx]fxtexman.obj,[.fx]fxddspan.obj,[.fx]fxcva.obj

##### RULES #####

VERSION=Mesa V3.1

##### TARGETS #####
# Make the library
$(LIBDIR)$(GL_LIB) : $(OBJECTS),$(OBJECTS2) $(OBJECTS3) $(OBJECTS4)\
	$(OBJECTS5) $(OBJECTS8) $(OBJECTS7) $(OBJECTS6)
.ifdef SHARE
  @ WRITE_ SYS$OUTPUT "  generating mesagl1.opt"
  @ OPEN_/WRITE FILE  mesagl1.opt
  @ WRITE_ FILE "!"
  @ WRITE_ FILE "! mesagl1.opt generated by DESCRIP.$(MMS_EXT)" 
  @ WRITE_ FILE "!"
  @ WRITE_ FILE "IDENTIFICATION=""$(VERSION)"""
  @ WRITE_ FILE "GSMATCH=LEQUAL,3,1
  @ WRITE_ FILE "$(OBJECTS)"
  @ WRITE_ FILE "$(OBJECTS3)"
  @ WRITE_ FILE "$(OBJECTS4)"
  @ WRITE_ FILE "$(OBJECTS7)"
  @ WRITE_ FILE "$(OBJECTS6)"
  @ WRITE_ FILE "$(OBJECTS2)"
  @ WRITE_ FILE "$(OBJECTS5)"
  @ WRITE_ FILE "$(OBJECTS8)"
  @ WRITE_ FILE "SYS$SHARE:DECW$XEXTLIBSHR/SHARE"
  @ WRITE_ FILE "SYS$SHARE:DECW$XLIBSHR/SHARE"
  @ CLOSE_ FILE
  @ WRITE_ SYS$OUTPUT "  generating mesagl.map ..."
  @ LINK_/NODEB/NOSHARE/NOEXE/MAP=mesagl.map/FULL mesagl1.opt/OPT
  @ WRITE_ SYS$OUTPUT "  analyzing mesagl.map ..."
  @ @[-.vms]ANALYZE_MAP.COM mesagl.map mesagl.opt
  @ WRITE_ SYS$OUTPUT "  linking $(GL_LIB) ..."
  @ LINK_/NODEB/SHARE=$(GL_LIB)/MAP=mesagl.map/FULL mesagl1.opt/opt,mesagl.opt/opt
.else
  @ $(MAKELIB) $(GL_LIB) $(OBJECTS)
  @ library $(GL_LIB) $(OBJECTS2)
  @ library $(GL_LIB) $(OBJECTS3)
  @ library $(GL_LIB) $(OBJECTS4)
  @ library $(GL_LIB) $(OBJECTS5)
  @ library $(GL_LIB) $(OBJECTS8)
  @ library $(GL_LIB) $(OBJECTS7)
  @ library $(GL_LIB) $(OBJECTS6)
.endif
  @ rename $(GL_LIB)* $(LIBDIR)

clean :
	purge
	delete *.obj;*

aatriangle.obj : aatriangle.c

triangle.obj : triangle.c

pixeltex.obj : pixeltex.c

[.x86]x86.obj : [.x86]x86.c
	$(CC) $(CFLAGS) /obj=[.x86]x86.obj [.x86]x86.c
[.x]glxapi.obj : [.x]glxapi.c
	$(CC) $(CFLAGS) /obj=[.x]glxapi.obj [.x]glxapi.c
[.x]fakeglx.obj : [.x]fakeglx.c
	$(CC) $(CFLAGS) /obj=[.x]fakeglx.obj [.x]fakeglx.c
[.x]xfonts.obj : [.x]xfonts.c
	$(CC) $(CFLAGS) /obj=[.x]xfonts.obj [.x]xfonts.c
[.x]xmesa1.obj : [.x]xmesa1.c
	$(CC) $(CFLAGS) /obj=[.x]xmesa1.obj [.x]xmesa1.c
[.x]xmesa2.obj : [.x]xmesa2.c
	$(CC) $(CFLAGS) /obj=[.x]xmesa2.obj [.x]xmesa2.c
[.x]xmesa3.obj : [.x]xmesa3.c
	$(CC) $(CFLAGS) /obj=[.x]xmesa3.obj [.x]xmesa3.c
[.x]xmesa4.obj : [.x]xmesa4.c
	$(CC) $(CFLAGS) /obj=[.x]xmesa4.obj [.x]xmesa4.c
[.osmesa]osmesa.obj : [.osmesa]osmesa.c
	$(CC) $(CFLAGS) /obj=[.osmesa]osmesa.obj [.osmesa]osmesa.c
[.svga]svgamesa.obj : [.svga]svgamesa.c
	$(CC) $(CFLAGS) /obj=[.svga]svgamesa.obj [.svga]svgamesa.c
[.fx]fxapi.obj : [.fx]fxapi.c
	$(CC) $(CFLAGS) /obj=[.fx]fxapi.obj [.fx]fxapi.c
[.fx]fxclip.obj : [.fx]fxclip.c
	$(CC) $(CFLAGS) /obj=[.fx]fxclip.obj [.fx]fxclip.c
[.fx]fxcva.obj : [.fx]fxcva.c
	$(CC) $(CFLAGS) /obj=[.fx]fxcva.obj [.fx]fxcva.c
[.fx]fxdd.obj : [.fx]fxdd.c
	$(CC) $(CFLAGS) /obj=[.fx]fxdd.obj [.fx]fxdd.c
[.fx]fxddtex.obj : [.fx]fxddtex.c
	$(CC) $(CFLAGS) /obj=[.fx]fxddtex.obj [.fx]fxddtex.c
[.fx]fxfastpath.obj : [.fx]fxfastpath.c
	$(CC) $(CFLAGS) /obj=[.fx]fxfastpath.obj [.fx]fxfastpath.c
[.fx]fxpipeline.obj : [.fx]fxpipeline.c
	$(CC) $(CFLAGS) /obj=[.fx]fxpipeline.obj [.fx]fxpipeline.c
[.fx]fxsanity.obj : [.fx]fxsanity.c
	$(CC) $(CFLAGS) /obj=[.fx]fxsanity.obj [.fx]fxsanity.c
[.fx]fxvsetup.obj : [.fx]fxvsetup.c
	$(CC) $(CFLAGS) /obj=[.fx]fxvsetup.obj [.fx]fxvsetup.c
[.fx]fxsetup.obj : [.fx]fxsetup.c
	$(CC) $(CFLAGS) /obj=[.fx]fxsetup.obj [.fx]fxsetup.c
[.fx]fxtrifuncs.obj : [.fx]fxtrifuncs.c
	$(CC) $(CFLAGS) /obj=[.fx]fxtrifuncs.obj [.fx]fxtrifuncs.c
[.fx]fxrender.obj : [.fx]fxrender.c
	$(CC) $(CFLAGS) /obj=[.fx]fxrender.obj [.fx]fxrender.c
[.fx]fxtexman.obj : [.fx]fxtexman.c
	$(CC) $(CFLAGS) /obj=[.fx]fxtexman.obj [.fx]fxtexman.c
[.fx]fxddspan.obj : [.fx]fxddspan.c
	$(CC) $(CFLAGS) /obj=[.fx]fxddspan.obj [.fx]fxddspan.c
[.fx]fxglidew.obj : [.fx]fxglidew.c
	$(CC) $(CFLAGS) /obj=[.fx]fxglidew.obj [.fx]fxglidew.c

.include mms_depend.
