/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.engine;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Vector;
import sun.plugin.converter.engine.ConvertSet;
import sun.plugin.converter.util.FlexFilter;
import sun.plugin.converter.util.NotDirectoryException;

public class DefaultSet
implements ConvertSet {
    private File sourcePath;
    private File destPath;
    private File backupPath;
    private Vector files = new Vector();
    private String destPathSuffix = "_CONV";
    private String backupPathSuffix = "_BAK";
    private int maxFileCharLength = 27;
    private boolean debug = true;
    private FilenameFilter cFlexFilter;

    public DefaultSet() {
        try {
            FlexFilter flexFilter = new FlexFilter();
            flexFilter.addDescriptor("*.html");
            flexFilter.addDescriptor("*.htm");
            flexFilter.addDescriptor("*.asp");
            flexFilter.setFilesOnly(true);
            this.setSourcePath(this.getDefaultSourcePath(), flexFilter);
            this.setDestinationPath(this.getDefaultDestPath());
            this.setBackupPath(this.getDefaultBackupPath());
        }
        catch (NotDirectoryException notDirectoryException) {
            notDirectoryException.printStackTrace();
        }
    }

    public void setSourcePath(File file, FilenameFilter filenameFilter) throws NotDirectoryException {
        if (!file.isDirectory()) {
            throw new NotDirectoryException(file.getAbsolutePath());
        }
        this.sourcePath = file;
        this.setFiles(filenameFilter);
        this.cFlexFilter = filenameFilter;
    }

    public File getSourcePath() {
        if (this.sourcePath == null) {
            return this.getDefaultSourcePath();
        }
        if (this.sourcePath.getAbsolutePath().endsWith("/.")) {
            this.sourcePath = new File(this.sourcePath.getParent());
            return this.sourcePath;
        }
        return this.sourcePath;
    }

    public File getDefaultSourcePath() {
        return new File(System.getProperty("user.dir"));
    }

    public void setBackupPath(File file) {
        this.backupPath = file;
    }

    public File getBackupPath() {
        if (this.backupPath == null) {
            return this.getDefaultBackupPath();
        }
        return this.backupPath;
    }

    public File getDefaultBackupPath() {
        String string = this.getSourcePath().getName();
        String string2 = this.sourcePath.getParent();
        string = this.truncateString(string, this.maxFileCharLength);
        string = string + this.backupPathSuffix;
        return new File(string2, string);
    }

    public String truncateString(String string, int n) {
        if (string.length() > n) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    public void setDestinationPath(File file) {
        this.destPath = file;
    }

    public File getDestinationPath() {
        return this.destPath;
    }

    public File getDefaultDestPath() {
        return this.sourcePath;
    }

    public void setFiles(FilenameFilter filenameFilter) {
        String[] stringArray = this.sourcePath.list(filenameFilter);
        this.files = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            this.files.addElement(stringArray[n]);
            ++n;
        }
    }

    public void setFile(File file) {
        this.sourcePath = file.getParentFile();
        this.files = new Vector();
        this.files.addElement(file.getName());
    }

    public Enumeration getFilesEnumeration() {
        return this.files.elements();
    }

    public Vector getFiles() {
        return this.files;
    }

    public int getFileCount() {
        return this.files.size();
    }

    public FilenameFilter getFilenameFilter() {
        return this.cFlexFilter;
    }

    public String toString() {
        String string = "\nSource Path:  " + this.sourcePath.toString();
        string = string + "\nFile count:  " + this.files.size();
        string = string + "\nFiles:  ";
        int n = 0;
        while (n < this.files.size()) {
            string = string + "\n     " + (String)this.files.elementAt(n);
            ++n;
        }
        string = string + "\nDest. Path:  " + this.destPath.toString();
        string = string + "\nBackup Path:  " + this.backupPath.toString();
        string = string + "\nCopy All:  false";
        string = string + "\nDest Path Suffix:  " + this.destPathSuffix;
        string = string + "\nMax File Char Length:  27";
        string = string + "\ndebug:  true";
        return string;
    }
}

